/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public record ColumnInfo(ColumnHandle handle, String name, Type type, boolean nullable, Optional<String> comment) {
    public ColumnInfo {
        Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(comment, "comment is null");
    }

    @JsonIgnore
    public ColumnMetadata getMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.type).setNullable(this.nullable).setComment(this.comment).build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("nullable", this.nullable).add("comment", this.comment).toString();
    }
}

