/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.memory.MemoryConfig;
import io.trino.plugin.memory.MemoryDataFragment;
import io.trino.plugin.memory.MemoryMetadata;
import io.trino.plugin.memory.MemorySplit;
import io.trino.plugin.memory.MemoryTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;

public final class MemorySplitManager
implements ConnectorSplitManager {
    private final int splitsPerNode;
    private final MemoryMetadata metadata;
    private final boolean enableLazyDynamicFiltering;

    @Inject
    public MemorySplitManager(MemoryConfig config, MemoryMetadata metadata) {
        this.splitsPerNode = config.getSplitsPerNode();
        this.metadata = metadata;
        this.enableLazyDynamicFiltering = config.isEnableLazyDynamicFiltering();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableHandle handle, DynamicFilter dynamicFilter, Constraint constraint) {
        MemoryTableHandle table = (MemoryTableHandle)handle;
        List<MemoryDataFragment> dataFragments = this.metadata.getDataFragments(table.getId());
        long totalRows = 0L;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (MemoryDataFragment dataFragment : dataFragments) {
            long rows = dataFragment.getRows();
            if (table.getLimit().isPresent() && (totalRows += rows) > table.getLimit().getAsLong()) {
                splits.add((Object)new MemorySplit(table.getId(), 0, 1, dataFragment.getHostAddress(), rows -= totalRows - table.getLimit().getAsLong(), OptionalLong.of(rows)));
                break;
            }
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new MemorySplit(table.getId(), i, this.splitsPerNode, dataFragment.getHostAddress(), rows, OptionalLong.empty()));
            }
        }
        Object splitSource = new FixedSplitSource((Iterable)splits.build());
        if (this.enableLazyDynamicFiltering) {
            splitSource = new DelayedSplitSource(MemorySplitManager.whenCompleted(dynamicFilter), (ConnectorSplitSource)splitSource);
        }
        return splitSource;
    }

    private static CompletableFuture<?> whenCompleted(DynamicFilter dynamicFilter) {
        if (dynamicFilter.isAwaitable()) {
            return dynamicFilter.isBlocked().thenCompose(ignored -> MemorySplitManager.whenCompleted(dynamicFilter));
        }
        return DynamicFilter.NOT_BLOCKED;
    }

    private static class DelayedSplitSource
    implements ConnectorSplitSource {
        private final CompletableFuture<?> delay;
        private final ConnectorSplitSource delegate;

        public DelayedSplitSource(CompletableFuture<?> delay, ConnectorSplitSource delegate) {
            this.delay = Objects.requireNonNull(delay, "delay is null");
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
            return this.delay.thenCompose(ignored -> this.delegate.getNextBatch(maxSize));
        }

        public void close() {
            this.delegate.close();
        }

        public boolean isFinished() {
            if (this.delay.isDone()) {
                return this.delegate.isFinished();
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("delay", this.delay).add("delegate", (Object)this.delegate).toString();
        }
    }
}

