/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.memory.MemoryConfig;
import io.trino.plugin.memory.MemoryDataFragment;
import io.trino.plugin.memory.MemoryMetadata;
import io.trino.plugin.memory.MemorySplit;
import io.trino.plugin.memory.MemoryTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.OptionalLong;
import javax.inject.Inject;

public final class MemorySplitManager
implements ConnectorSplitManager {
    private final int splitsPerNode;
    private final MemoryMetadata metadata;

    @Inject
    public MemorySplitManager(MemoryConfig config, MemoryMetadata metadata) {
        this.splitsPerNode = config.getSplitsPerNode();
        this.metadata = metadata;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableHandle handle, DynamicFilter dynamicFilter, Constraint constraint) {
        MemoryTableHandle table = (MemoryTableHandle)handle;
        List<MemoryDataFragment> dataFragments = this.metadata.getDataFragments(table.getId());
        int totalRows = 0;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (MemoryDataFragment dataFragment : dataFragments) {
            long rows = dataFragment.getRows();
            totalRows = (int)((long)totalRows + rows);
            if (table.getLimit().isPresent() && (long)totalRows > table.getLimit().getAsLong()) {
                splits.add((Object)new MemorySplit(table.getId(), 0, 1, dataFragment.getHostAddress(), rows -= (long)totalRows - table.getLimit().getAsLong(), OptionalLong.of(rows)));
                break;
            }
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new MemorySplit(table.getId(), i, this.splitsPerNode, dataFragment.getHostAddress(), rows, OptionalLong.empty()));
            }
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

