/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import io.trino.plugin.memory.MemoryColumnHandle;
import io.trino.plugin.memory.MemoryConfig;
import io.trino.plugin.memory.MemoryPagesStore;
import io.trino.plugin.memory.MemorySplit;
import io.trino.plugin.memory.MemoryTableHandle;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;

public final class MemoryPageSourceProvider
implements ConnectorPageSourceProvider {
    private final MemoryPagesStore pagesStore;
    private final boolean enableLazyDynamicFiltering;

    @Inject
    public MemoryPageSourceProvider(MemoryPagesStore pagesStore, MemoryConfig config) {
        this.pagesStore = Objects.requireNonNull(pagesStore, "pagesStore is null");
        this.enableLazyDynamicFiltering = config.isEnableLazyDynamicFiltering();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        MemorySplit memorySplit = (MemorySplit)split;
        long tableId = memorySplit.getTable();
        int partNumber = memorySplit.getPartNumber();
        int totalParts = memorySplit.getTotalPartsPerWorker();
        long expectedRows = memorySplit.getExpectedRows();
        MemoryTableHandle memoryTable = (MemoryTableHandle)table;
        OptionalDouble sampleRatio = memoryTable.getSampleRatio();
        List<Integer> columnIndexes = columns.stream().map(MemoryColumnHandle.class::cast).map(MemoryColumnHandle::getColumnIndex).collect(Collectors.toList());
        List<Page> pages = this.pagesStore.getPages(tableId, partNumber, totalParts, columnIndexes, expectedRows, memorySplit.getLimit(), sampleRatio);
        return new DynamicFilteringPageSource(new FixedPageSource(pages), columns, dynamicFilter, this.enableLazyDynamicFiltering);
    }

    private static Page applyFilter(Page page, Map<Integer, Domain> domains) {
        int[] positions = new int[page.getPositionCount()];
        int length = 0;
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!MemoryPageSourceProvider.positionMatchesPredicate(page, position, domains)) continue;
            positions[length++] = position;
        }
        return page.getPositions(positions, 0, length);
    }

    private static boolean positionMatchesPredicate(Page page, int position, Map<Integer, Domain> domains) {
        for (Map.Entry<Integer, Domain> entry : domains.entrySet()) {
            Object value;
            int channel = entry.getKey();
            Domain domain = entry.getValue();
            if (domain.includesNullableValue(value = TypeUtils.readNativeValue((Type)domain.getType(), (Block)page.getBlock(channel), (int)position))) continue;
            return false;
        }
        return true;
    }

    private static class DynamicFilteringPageSource
    implements ConnectorPageSource {
        private final FixedPageSource delegate;
        private final List<ColumnHandle> columns;
        private final DynamicFilter dynamicFilter;
        private final boolean enableLazyDynamicFiltering;

        private DynamicFilteringPageSource(FixedPageSource delegate, List<ColumnHandle> columns, DynamicFilter dynamicFilter, boolean enableLazyDynamicFiltering) {
            this.delegate = delegate;
            this.columns = columns;
            this.dynamicFilter = dynamicFilter;
            this.enableLazyDynamicFiltering = enableLazyDynamicFiltering;
        }

        public long getCompletedBytes() {
            return this.delegate.getCompletedBytes();
        }

        public long getReadTimeNanos() {
            return this.delegate.getReadTimeNanos();
        }

        public boolean isFinished() {
            return this.delegate.isFinished();
        }

        public Page getNextPage() {
            if (this.enableLazyDynamicFiltering && this.dynamicFilter.isAwaitable()) {
                return null;
            }
            TupleDomain predicate = this.dynamicFilter.getCurrentPredicate();
            if (predicate.isNone()) {
                this.close();
                return null;
            }
            Page page = this.delegate.getNextPage();
            if (page != null && !predicate.isAll()) {
                page = MemoryPageSourceProvider.applyFilter(page, (Map)predicate.transform(this.columns::indexOf).getDomains().get());
            }
            return page;
        }

        public CompletableFuture<?> isBlocked() {
            if (this.enableLazyDynamicFiltering) {
                return this.dynamicFilter.isBlocked();
            }
            return NOT_BLOCKED;
        }

        public long getSystemMemoryUsage() {
            return this.delegate.getSystemMemoryUsage();
        }

        public void close() {
            this.delegate.close();
        }
    }
}

