/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.memory.ColumnInfo;
import io.trino.plugin.memory.MemoryDataFragment;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableInfo {
    private final long id;
    private final String schemaName;
    private final String tableName;
    private final List<ColumnInfo> columns;
    private final Map<HostAddress, MemoryDataFragment> dataFragments;

    public TableInfo(long id, String schemaName, String tableName, List<ColumnInfo> columns, Map<HostAddress, MemoryDataFragment> dataFragments) {
        this.id = Objects.requireNonNull(Long.valueOf(id), "handle is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columns = ImmutableList.copyOf(columns);
        this.dataFragments = ImmutableMap.copyOf(dataFragments);
    }

    public long getId() {
        return this.id;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public ConnectorTableMetadata getMetadata() {
        return new ConnectorTableMetadata(new SchemaTableName(this.schemaName, this.tableName), this.columns.stream().map(ColumnInfo::getMetadata).collect(Collectors.toList()));
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public ColumnInfo getColumn(ColumnHandle handle) {
        return this.columns.stream().filter(column -> column.getHandle().equals(handle)).findFirst().get();
    }

    public Map<HostAddress, MemoryDataFragment> getDataFragments() {
        return this.dataFragments;
    }
}

