/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory.context;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.memory.context.LocalMemoryContext;
import java.util.Objects;

public class CoarseGrainLocalMemoryContext
implements LocalMemoryContext {
    public static final long DEFAULT_GRANULARITY = 65536L;
    private final LocalMemoryContext delegate;
    private final long granularity;
    private final long mask;
    @GuardedBy(value="this")
    private long currentBytes;

    public CoarseGrainLocalMemoryContext(LocalMemoryContext delegate) {
        this(delegate, 65536L);
    }

    public CoarseGrainLocalMemoryContext(LocalMemoryContext delegate, long granularity) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Preconditions.checkArgument((granularity > 0L ? 1 : 0) != 0, (Object)"granularity must be greater than 0");
        Preconditions.checkArgument(((granularity & granularity - 1L) == 0L ? 1 : 0) != 0, (Object)"granularity must be a power of 2");
        this.granularity = granularity;
        this.mask = granularity - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public synchronized long getBytes() {
        return this.currentBytes;
    }

    @Override
    public synchronized ListenableFuture<Void> setBytes(long bytes) {
        long roundedUpBytes = this.roundUpToNearest(bytes);
        if (roundedUpBytes != this.currentBytes) {
            this.currentBytes = roundedUpBytes;
            return this.delegate.setBytes(this.currentBytes);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public synchronized ListenableFuture<Void> addBytes(long delta) {
        return this.setBytes(Math.addExact(this.currentBytes, delta));
    }

    @Override
    public synchronized boolean trySetBytes(long bytes) {
        long roundedUpBytes = this.roundUpToNearest(bytes);
        if (roundedUpBytes != this.currentBytes) {
            if (this.delegate.trySetBytes(roundedUpBytes)) {
                this.currentBytes = roundedUpBytes;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        this.delegate.close();
        this.currentBytes = 0L;
    }

    @VisibleForTesting
    long roundUpToNearest(long bytes) {
        long masked = bytes & this.mask;
        return masked == bytes ? masked : masked + this.granularity;
    }
}

