/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory.context;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.memory.context.AbstractAggregatedMemoryContext;
import io.trino.memory.context.AggregatedMemoryContext;
import java.util.Objects;

class ChildAggregatedMemoryContext
extends AbstractAggregatedMemoryContext {
    private final AbstractAggregatedMemoryContext parentMemoryContext;

    ChildAggregatedMemoryContext(AggregatedMemoryContext parentMemoryContext) {
        Verify.verify((boolean)(parentMemoryContext instanceof AbstractAggregatedMemoryContext));
        this.parentMemoryContext = (AbstractAggregatedMemoryContext)Objects.requireNonNull(parentMemoryContext, "parentMemoryContext is null");
    }

    @Override
    synchronized ListenableFuture<Void> updateBytes(String allocationTag, long delta) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"ChildAggregatedMemoryContext is already closed");
        ListenableFuture<Void> future = this.parentMemoryContext.updateBytes(allocationTag, delta);
        this.addBytes(delta);
        return future;
    }

    @Override
    synchronized boolean tryUpdateBytes(String allocationTag, long delta) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"ChildAggregatedMemoryContext is already closed");
        if (this.parentMemoryContext.tryUpdateBytes(allocationTag, delta)) {
            this.addBytes(delta);
            return true;
        }
        return false;
    }

    @Override
    void closeContext() {
        this.parentMemoryContext.updateBytes("FORCE_FREE_OPERATION", -this.getBytes());
    }
}

