/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.google.inject.Inject;
import io.trino.plugin.google.sheets.SheetsClient;
import io.trino.plugin.google.sheets.SheetsConnectorInsertTableHandle;
import io.trino.plugin.google.sheets.SheetsPageSink;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public class SheetsPageSinkProvider
implements ConnectorPageSinkProvider {
    private final SheetsClient sheetsClient;

    @Inject
    public SheetsPageSinkProvider(SheetsClient sheetsClient) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        throw new UnsupportedOperationException("Google Sheets connector does not support creating page sinks using a ConnectorOutputTableHandle");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        SheetsConnectorInsertTableHandle handle = (SheetsConnectorInsertTableHandle)insertTableHandle;
        return new SheetsPageSink(this.sheetsClient, handle.getTableName(), handle.getColumns());
    }
}

