/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.google.sheets.SheetsClient;
import io.trino.plugin.google.sheets.SheetsColumnHandle;
import io.trino.plugin.google.sheets.SheetsConnectorInsertTableHandle;
import io.trino.plugin.google.sheets.SheetsConnectorTableHandle;
import io.trino.plugin.google.sheets.SheetsErrorCode;
import io.trino.plugin.google.sheets.SheetsNamedTableHandle;
import io.trino.plugin.google.sheets.SheetsSheetTableHandle;
import io.trino.plugin.google.sheets.SheetsTable;
import io.trino.plugin.google.sheets.ptf.Sheet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.statistics.ComputedStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SheetsMetadata
implements ConnectorMetadata {
    private final SheetsClient sheetsClient;
    private static final List<String> SCHEMAS = ImmutableList.of((Object)"default");

    @Inject
    public SheetsMetadata(SheetsClient sheetsClient) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.listSchemaNames();
    }

    public List<String> listSchemaNames() {
        return SCHEMAS;
    }

    public SheetsNamedTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName())) {
            return null;
        }
        Optional<SheetsTable> table = this.sheetsClient.getTable(tableName.getTableName());
        if (table.isEmpty()) {
            return null;
        }
        return new SheetsNamedTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        SheetsConnectorTableHandle tableHandle = (SheetsConnectorTableHandle)table;
        SheetsTable sheetsTable = this.sheetsClient.getTable(tableHandle).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_UNKNOWN_TABLE_ERROR, "Metadata not found for table " + SheetsConnectorTableHandle.tableNotFound(tableHandle)));
        return new ConnectorTableMetadata(SheetsMetadata.getSchemaTableName(tableHandle), sheetsTable.getColumnsMetadata());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SheetsConnectorTableHandle sheetsTableHandle = (SheetsConnectorTableHandle)tableHandle;
        SheetsTable table = this.sheetsClient.getTable(sheetsTableHandle).orElseThrow(() -> SheetsConnectorTableHandle.tableNotFound(sheetsTableHandle));
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : table.getColumnsMetadata()) {
            columnHandles.put((Object)column.getName(), (Object)new SheetsColumnHandle(column.getName(), column.getType(), index));
            ++index;
        }
        return columnHandles.buildOrThrow();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchema())) {
            Optional<ConnectorTableMetadata> tableMetadata = this.getTableMetadata(tableName);
            if (!tableMetadata.isPresent()) continue;
            columns.put((Object)tableName, (Object)tableMetadata.get().getColumns());
        }
        return columns.buildOrThrow();
    }

    private Optional<ConnectorTableMetadata> getTableMetadata(SchemaTableName tableName) {
        if (!this.listSchemaNames().contains(tableName.getSchemaName())) {
            return Optional.empty();
        }
        Optional<SheetsTable> table = this.sheetsClient.getTable(tableName.getTableName());
        if (table.isPresent()) {
            return Optional.of(new ConnectorTableMetadata(tableName, table.get().getColumnsMetadata()));
        }
        return Optional.empty();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        String schema = schemaName.orElseGet(() -> (String)Iterables.getOnlyElement(SCHEMAS));
        if (this.listSchemaNames().contains(schema)) {
            return (List)this.sheetsClient.getTableNames().stream().map(tableName -> new SchemaTableName(schema, tableName)).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((SheetsColumnHandle)columnHandle).getColumnMetadata();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        if (!(tableHandle instanceof SheetsNamedTableHandle)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Can only insert into named tables. Found table handle type: %s", tableHandle));
        }
        SheetsNamedTableHandle namedTableHandle = (SheetsNamedTableHandle)tableHandle;
        SheetsTable table = this.sheetsClient.getTable(namedTableHandle.getTableName()).orElseThrow(() -> new TableNotFoundException(namedTableHandle.getSchemaTableName()));
        ArrayList<SheetsColumnHandle> columnHandles = new ArrayList<SheetsColumnHandle>(table.getColumnsMetadata().size());
        for (int id = 0; id < table.getColumnsMetadata().size(); ++id) {
            columnHandles.add(new SheetsColumnHandle(table.getColumnsMetadata().get(id).getName(), table.getColumnsMetadata().get(id).getType(), id));
        }
        return new SheetsConnectorInsertTableHandle(namedTableHandle.getTableName(), columnHandles);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        if (!(handle instanceof Sheet.SheetFunctionHandle)) {
            return Optional.empty();
        }
        ConnectorTableHandle tableHandle = ((Sheet.SheetFunctionHandle)handle).getTableHandle();
        ImmutableList columnHandles = ImmutableList.copyOf(this.getColumnHandles(session, tableHandle).values());
        return Optional.of(new TableFunctionApplicationResult((Object)tableHandle, (List)columnHandles));
    }

    private static SchemaTableName getSchemaTableName(SheetsConnectorTableHandle handle) {
        if (handle instanceof SheetsNamedTableHandle) {
            SheetsNamedTableHandle namedTableHandle = (SheetsNamedTableHandle)handle;
            return new SchemaTableName(namedTableHandle.getSchemaName(), namedTableHandle.getTableName());
        }
        if (handle instanceof SheetsSheetTableHandle) {
            return new SchemaTableName("_generated", "_generated");
        }
        throw new IllegalStateException("Found unexpected table handle type " + handle);
    }
}

