/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public class SheetsSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SheetsSplit.class);
    private final List<List<String>> values;

    @JsonCreator
    public SheetsSplit(@JsonProperty(value="values") List<List<String>> values) {
        this.values = Objects.requireNonNull(values, "values is null");
    }

    @JsonProperty
    public List<List<String>> getValues() {
        return this.values;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public Object getInfo() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return builder.buildOrThrow();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.values, value -> SizeOf.estimatedSizeOf((List)value, SizeOf::estimatedSizeOf));
    }
}

