/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.google.sheets.SheetsClient;
import io.trino.plugin.google.sheets.SheetsColumnHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class SheetsPageSink
implements ConnectorPageSink {
    private final SheetsClient sheetsClient;
    private final String tableName;
    private final List<SheetsColumnHandle> columns;

    public SheetsPageSink(SheetsClient sheetsClient, String tableName, List<SheetsColumnHandle> columns) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    public CompletableFuture<?> appendPage(Page page) {
        String sheetExpression = this.sheetsClient.getCachedSheetExpressionForTable(this.tableName);
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (int position = 0; position < page.getPositionCount(); ++position) {
            ArrayList<String> row = new ArrayList<String>();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                row.add(this.getObjectValue(this.columns.get(channel).getColumnType(), page.getBlock(channel), position));
            }
            rows.add(row);
        }
        this.sheetsClient.insertIntoSheet(sheetExpression, rows);
        return NOT_BLOCKED;
    }

    private String getObjectValue(Type type, Block block, int position) {
        if (type.equals(VarcharType.VARCHAR)) {
            return type.getSlice(block, position).toStringUtf8();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type " + type + " when writing to Google sheets tables");
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
    }
}

