/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import io.trino.plugin.google.sheets.SheetsClient;
import io.trino.plugin.google.sheets.SheetsConnectorTableHandle;
import io.trino.plugin.google.sheets.SheetsNamedTableHandle;
import io.trino.plugin.google.sheets.SheetsSheetTableHandle;
import io.trino.plugin.google.sheets.SheetsSplit;
import io.trino.plugin.google.sheets.SheetsTable;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SheetsSplitManager
implements ConnectorSplitManager {
    private final SheetsClient sheetsClient;

    @Inject
    public SheetsSplitManager(SheetsClient sheetsClient) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle connectorTableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        SheetsConnectorTableHandle tableHandle = (SheetsConnectorTableHandle)connectorTableHandle;
        SheetsTable table = this.sheetsClient.getTable(tableHandle).orElseThrow(() -> SheetsConnectorTableHandle.tableNotFound(tableHandle));
        ArrayList<SheetsSplit> splits = new ArrayList<SheetsSplit>();
        splits.add(SheetsSplitManager.sheetsSplitFromTableHandle(tableHandle, table.getValues()));
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }

    private static SheetsSplit sheetsSplitFromTableHandle(SheetsConnectorTableHandle tableHandle, List<List<String>> values) {
        if (tableHandle instanceof SheetsNamedTableHandle) {
            SheetsNamedTableHandle namedTableHandle = (SheetsNamedTableHandle)tableHandle;
            return new SheetsSplit(Optional.of(namedTableHandle.getSchemaName()), Optional.of(namedTableHandle.getTableName()), Optional.empty(), values);
        }
        if (tableHandle instanceof SheetsSheetTableHandle) {
            SheetsSheetTableHandle sheetTableHandle = (SheetsSheetTableHandle)tableHandle;
            return new SheetsSplit(Optional.empty(), Optional.empty(), Optional.of(sheetTableHandle.getSheetExpression()), values);
        }
        throw new IllegalStateException("Found unexpected table handle type " + tableHandle);
    }
}

