/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SheetsSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SheetsSplit.class);
    private final Optional<String> schemaName;
    private final Optional<String> tableName;
    private final Optional<String> sheetExpression;
    private final List<List<String>> values;
    private final List<HostAddress> hostAddresses;

    @JsonCreator
    public SheetsSplit(@JsonProperty(value="schemaName") Optional<String> schemaName, @JsonProperty(value="tableName") Optional<String> tableName, @JsonProperty(value="sheetExpression") Optional<String> sheetExpression, @JsonProperty(value="values") List<List<String>> values) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.sheetExpression = Objects.requireNonNull(sheetExpression, "sheetExpression is null");
        this.values = Objects.requireNonNull(values, "values is null");
        this.hostAddresses = ImmutableList.of();
    }

    @JsonProperty
    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public Optional<String> getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<String> getSheetExpression() {
        return this.sheetExpression;
    }

    @JsonProperty
    public List<List<String>> getValues() {
        return this.values;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return this.hostAddresses;
    }

    public Object getInfo() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"hostAddresses", this.hostAddresses);
        this.schemaName.ifPresent(name -> builder.put((Object)"schemaName", name));
        this.tableName.ifPresent(name -> builder.put((Object)"tableName", name));
        this.sheetExpression.ifPresent(expression -> builder.put((Object)"sheetExpression", expression));
        return builder.buildOrThrow();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.schemaName, SizeOf::estimatedSizeOf) + SizeOf.sizeOf(this.tableName, SizeOf::estimatedSizeOf) + SizeOf.sizeOf(this.sheetExpression, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.values, value -> SizeOf.estimatedSizeOf((List)value, SizeOf::estimatedSizeOf)) + SizeOf.estimatedSizeOf(this.hostAddresses, HostAddress::getRetainedSizeInBytes);
    }
}

