/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.google.common.collect.ImmutableSet;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.google.sheets.SheetsMetadata;
import io.trino.plugin.google.sheets.SheetsRecordSetProvider;
import io.trino.plugin.google.sheets.SheetsSplitManager;
import io.trino.plugin.google.sheets.SheetsTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class SheetsConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final SheetsMetadata metadata;
    private final SheetsSplitManager splitManager;
    private final SheetsRecordSetProvider recordSetProvider;
    private final Set<ConnectorTableFunction> connectorTableFunctions;

    @Inject
    public SheetsConnector(LifeCycleManager lifeCycleManager, SheetsMetadata metadata, SheetsSplitManager splitManager, SheetsRecordSetProvider recordSetProvider, Set<ConnectorTableFunction> connectorTableFunctions) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.connectorTableFunctions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(connectorTableFunctions, "connectorTableFunctions is null"));
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return SheetsTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.connectorTableFunctions;
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

