/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.google.sheets.SheetsColumn;
import io.trino.spi.connector.ColumnMetadata;
import java.util.List;
import java.util.Objects;

public class SheetsTable {
    private final List<ColumnMetadata> columnsMetadata;
    private final List<List<Object>> values;

    @JsonCreator
    public SheetsTable(@JsonProperty(value="name") String name, @JsonProperty(value="columns") List<SheetsColumn> columns, @JsonProperty(value="values") List<List<Object>> values) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        Objects.requireNonNull(columns, "columns is null");
        ImmutableList.Builder columnsMetadata = ImmutableList.builder();
        for (SheetsColumn column : columns) {
            columnsMetadata.add((Object)new ColumnMetadata(column.getName(), column.getType()));
        }
        this.columnsMetadata = columnsMetadata.build();
        this.values = values;
    }

    @JsonProperty
    public List<List<Object>> getValues() {
        return this.values;
    }

    public List<ColumnMetadata> getColumnsMetadata() {
        return this.columnsMetadata;
    }
}

