/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import io.trino.plugin.google.sheets.SheetsClient;
import io.trino.plugin.google.sheets.SheetsSplit;
import io.trino.plugin.google.sheets.SheetsTable;
import io.trino.plugin.google.sheets.SheetsTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.TableNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SheetsSplitManager
implements ConnectorSplitManager {
    private final SheetsClient sheetsClient;

    @Inject
    public SheetsSplitManager(SheetsClient sheetsClient) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle connectorTableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        SheetsTableHandle tableHandle = (SheetsTableHandle)connectorTableHandle;
        Optional<SheetsTable> table = this.sheetsClient.getTable(tableHandle.getTableName());
        if (table.isEmpty()) {
            throw new TableNotFoundException(tableHandle.toSchemaTableName());
        }
        ArrayList<SheetsSplit> splits = new ArrayList<SheetsSplit>();
        splits.add(new SheetsSplit(tableHandle.getSchemaName(), tableHandle.getTableName(), table.get().getValues()));
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }
}

