/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public class SheetsSplit
implements ConnectorSplit {
    private final String schemaName;
    private final String tableName;
    private final List<List<Object>> values;
    private final List<HostAddress> hostAddresses;

    @JsonCreator
    public SheetsSplit(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="values") List<List<Object>> values) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.values = Objects.requireNonNull(values, "values is null");
        this.hostAddresses = ImmutableList.of();
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<List<Object>> getValues() {
        return this.values;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return this.hostAddresses;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"schemaName", (Object)this.schemaName).put((Object)"tableName", (Object)this.tableName).put((Object)"hostAddresses", this.hostAddresses).build();
    }
}

