/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.google.sheets.SheetsConnector;
import io.trino.plugin.google.sheets.SheetsHandleResolver;
import io.trino.plugin.google.sheets.SheetsModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorHandleResolver;
import java.util.Map;
import java.util.Objects;

public class SheetsConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "gsheets";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new SheetsHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new TypeDeserializerModule(context.getTypeManager()), new SheetsModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(SheetsConnector.class);
    }
}

