/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.google.sheets;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class SheetsConfig {
    private String credentialsFilePath;
    private String metadataSheetId;
    private int sheetsDataMaxCacheSize = 1000;
    private Duration sheetsDataExpireAfterWrite = new Duration(5.0, TimeUnit.MINUTES);

    @NotNull
    @FileExists
    public String getCredentialsFilePath() {
        return this.credentialsFilePath;
    }

    @Config(value="credentials-path")
    @ConfigDescription(value="Credential file path to google service account")
    public SheetsConfig setCredentialsFilePath(String credentialsFilePath) {
        this.credentialsFilePath = credentialsFilePath;
        return this;
    }

    @NotNull
    public String getMetadataSheetId() {
        return this.metadataSheetId;
    }

    @Config(value="metadata-sheet-id")
    @ConfigDescription(value="Metadata sheet id containing table sheet mapping")
    public SheetsConfig setMetadataSheetId(String metadataSheetId) {
        this.metadataSheetId = metadataSheetId;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSheetsDataMaxCacheSize() {
        return this.sheetsDataMaxCacheSize;
    }

    @Config(value="sheets-data-max-cache-size")
    @ConfigDescription(value="Sheet data max cache size")
    public SheetsConfig setSheetsDataMaxCacheSize(int sheetsDataMaxCacheSize) {
        this.sheetsDataMaxCacheSize = sheetsDataMaxCacheSize;
        return this;
    }

    @MinDuration(value="1m")
    public @MinDuration(value="1m") Duration getSheetsDataExpireAfterWrite() {
        return this.sheetsDataExpireAfterWrite;
    }

    @Config(value="sheets-data-expire-after-write")
    @ConfigDescription(value="Sheets data expire after write duration")
    public SheetsConfig setSheetsDataExpireAfterWrite(Duration sheetsDataExpireAfterWriteMinutes) {
        this.sheetsDataExpireAfterWrite = sheetsDataExpireAfterWriteMinutes;
        return this;
    }
}

