/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.geospatial;

import io.airlift.slice.Slice;
import io.trino.geospatial.serde.GeometrySerde;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public class SphericalGeographyType
extends AbstractVariableWidthType {
    public static final SphericalGeographyType SPHERICAL_GEOGRAPHY = new SphericalGeographyType();
    public static final String SPHERICAL_GEOGRAPHY_TYPE_NAME = "SphericalGeography";

    private SphericalGeographyType() {
        super(new TypeSignature(SPHERICAL_GEOGRAPHY_TYPE_NAME, new TypeSignatureParameter[0]), Slice.class);
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getSliceLength(position));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(value, offset, length);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, block.getSliceLength(position));
        return GeometrySerde.deserialize((Slice)slice).asText();
    }
}

