/*
 * Decompiled with CFR 0.152.
 */
package io.trino.geospatial;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.util.Objects;

public final class Rectangle {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Rectangle.class);
    private final double xMin;
    private final double yMin;
    private final double xMax;
    private final double yMax;

    @JsonCreator
    public Rectangle(@JsonProperty(value="xmin") double xMin, @JsonProperty(value="ymin") double yMin, @JsonProperty(value="xmax") double xMax, @JsonProperty(value="ymax") double yMax) {
        Preconditions.checkArgument((xMin <= xMax ? 1 : 0) != 0, (Object)"xMin is greater than xMax");
        Preconditions.checkArgument((yMin <= yMax ? 1 : 0) != 0, (Object)"yMin is greater than yMax");
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
    }

    @JsonProperty
    public double getXMin() {
        return this.xMin;
    }

    @JsonProperty
    public double getYMin() {
        return this.yMin;
    }

    @JsonProperty
    public double getXMax() {
        return this.xMax;
    }

    @JsonProperty
    public double getYMax() {
        return this.yMax;
    }

    public double getWidth() {
        return this.xMax - this.xMin;
    }

    public double getHeight() {
        return this.yMax - this.yMin;
    }

    public boolean intersects(Rectangle other) {
        Objects.requireNonNull(other, "other is null");
        return this.xMin <= other.xMax && this.xMax >= other.xMin && this.yMin <= other.yMax && this.yMax >= other.yMin;
    }

    public Rectangle intersection(Rectangle other) {
        Objects.requireNonNull(other, "other is null");
        if (!this.intersects(other)) {
            return null;
        }
        return new Rectangle(Math.max(this.xMin, other.xMin), Math.max(this.yMin, other.yMin), Math.min(this.xMax, other.xMax), Math.min(this.yMax, other.yMax));
    }

    public Rectangle merge(Rectangle other) {
        return new Rectangle(Math.min(this.xMin, other.xMin), Math.min(this.yMin, other.yMin), Math.max(this.xMax, other.xMax), Math.max(this.yMax, other.yMax));
    }

    public int estimateMemorySize() {
        return INSTANCE_SIZE;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        return other.xMin == this.xMin && other.yMin == this.yMin && other.xMax == this.xMax && other.yMax == this.yMax;
    }

    public int hashCode() {
        return Objects.hash(this.xMin, this.yMin, this.xMax, this.yMax);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("xMin", this.xMin).add("yMin", this.yMin).add("xMax", this.xMax).add("yMax", this.yMax).toString();
    }
}

