/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.functions.python;

import com.dylibso.chicory.log.Logger;
import java.util.Objects;
import java.util.logging.Level;

final class JdkLogger
implements Logger {
    private final java.util.logging.Logger logger;

    public static Logger get(Class<?> clazz) {
        return new JdkLogger(java.util.logging.Logger.getLogger(clazz.getName()));
    }

    public JdkLogger(java.util.logging.Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    public void log(Logger.Level level, String msg, Throwable throwable) {
        this.logger.log(JdkLogger.toJdkLevel(level), msg, throwable);
    }

    public boolean isLoggable(Logger.Level level) {
        return this.logger.isLoggable(JdkLogger.toJdkLevel(level));
    }

    private static Level toJdkLevel(Logger.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case Logger.Level.ALL -> Level.ALL;
            case Logger.Level.TRACE -> Level.FINEST;
            case Logger.Level.DEBUG -> Level.FINE;
            case Logger.Level.INFO -> Level.INFO;
            case Logger.Level.WARNING -> Level.WARNING;
            case Logger.Level.ERROR -> Level.SEVERE;
            case Logger.Level.OFF -> Level.OFF;
        };
    }
}

