/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.example;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.example.ExampleColumn;
import io.trino.spi.connector.ColumnMetadata;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ExampleTable {
    private final String name;
    private final List<ExampleColumn> columns;
    private final List<ColumnMetadata> columnsMetadata;
    private final List<URI> sources;

    @JsonCreator
    public ExampleTable(@JsonProperty(value="name") String name, @JsonProperty(value="columns") List<ExampleColumn> columns, @JsonProperty(value="sources") List<URI> sources) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = Objects.requireNonNull(name, "name is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.sources = ImmutableList.copyOf((Collection)Objects.requireNonNull(sources, "sources is null"));
        ImmutableList.Builder columnsMetadata = ImmutableList.builder();
        for (ExampleColumn column : this.columns) {
            columnsMetadata.add((Object)new ColumnMetadata(column.getName(), column.getType()));
        }
        this.columnsMetadata = columnsMetadata.build();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<ExampleColumn> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<URI> getSources() {
        return this.sources;
    }

    public List<ColumnMetadata> getColumnsMetadata() {
        return this.columnsMetadata;
    }
}

