/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.example;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.trino.plugin.example.ExampleClient;
import io.trino.plugin.example.ExampleConfig;
import io.trino.plugin.example.ExampleConnector;
import io.trino.plugin.example.ExampleMetadata;
import io.trino.plugin.example.ExampleRecordSetProvider;
import io.trino.plugin.example.ExampleSplitManager;
import io.trino.plugin.example.ExampleTable;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Inject;

public class ExampleModule
implements Module {
    private final TypeManager typeManager;

    public ExampleModule(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(ExampleConnector.class).in(Scopes.SINGLETON);
        binder.bind(ExampleMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ExampleClient.class).in(Scopes.SINGLETON);
        binder.bind(ExampleSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ExampleRecordSetProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ExampleConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(ExampleTable.class));
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeId.of((String)value));
        }
    }
}

