/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.example;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.example.ExampleClient;
import io.trino.plugin.example.ExampleColumnHandle;
import io.trino.plugin.example.ExampleTable;
import io.trino.plugin.example.ExampleTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class ExampleMetadata
implements ConnectorMetadata {
    private final ExampleClient exampleClient;

    @Inject
    public ExampleMetadata(ExampleClient exampleClient) {
        this.exampleClient = Objects.requireNonNull(exampleClient, "client is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.listSchemaNames();
    }

    public List<String> listSchemaNames() {
        return ImmutableList.copyOf(this.exampleClient.getSchemaNames());
    }

    public ExampleTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName())) {
            return null;
        }
        ExampleTable table = this.exampleClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ExampleTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(((ExampleTableHandle)table).toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        Set schemaNames = (Set)optionalSchemaName.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf(this.exampleClient.getSchemaNames()));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : schemaNames) {
            for (String tableName : this.exampleClient.getTableNames(schemaName)) {
                builder.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ExampleTableHandle exampleTableHandle = (ExampleTableHandle)tableHandle;
        ExampleTable table = this.exampleClient.getTable(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(exampleTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : table.getColumnsMetadata()) {
            columnHandles.put((Object)column.getName(), (Object)new ExampleColumnHandle(column.getName(), column.getType(), index));
            ++index;
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        if (!this.listSchemaNames().contains(tableName.getSchemaName())) {
            return null;
        }
        ExampleTable table = this.exampleClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ConnectorTableMetadata(tableName, table.getColumnsMetadata());
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((ExampleColumnHandle)columnHandle).getColumnMetadata();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }
}

