/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.kerberos;

import io.airlift.units.Duration;
import io.trino.client.auth.kerberos.GSSContextProvider;
import java.util.concurrent.TimeUnit;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public abstract class BaseGSSContextProvider
implements GSSContextProvider {
    protected static final GSSManager GSS_MANAGER = GSSManager.getInstance();
    protected static final Oid SPNEGO_OID = BaseGSSContextProvider.createOid("1.3.6.1.5.5.2");
    protected static final Oid KERBEROS_OID = BaseGSSContextProvider.createOid("1.2.840.113554.1.2.2");
    protected static final Duration MIN_CREDENTIAL_LIFETIME = new Duration(60.0, TimeUnit.SECONDS);

    protected GSSContext createContext(String servicePrincipal, GSSCredential gssCredential) throws GSSException {
        GSSContext result = GSS_MANAGER.createContext(GSS_MANAGER.createName(servicePrincipal, GSSName.NT_HOSTBASED_SERVICE), SPNEGO_OID, gssCredential, Integer.MAX_VALUE);
        result.requestMutualAuth(true);
        result.requestConf(true);
        result.requestInteg(true);
        result.requestCredDeleg(true);
        return result;
    }

    static Oid createOid(String value) {
        try {
            return new Oid(value);
        }
        catch (GSSException e) {
            throw new AssertionError((Object)e);
        }
    }
}

