/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.client.ClientTypeSignatureParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Immutable
public class ClientTypeSignature {
    private static final Pattern PATTERN = Pattern.compile(".*[<>,].*");
    private final String rawType;
    private final List<ClientTypeSignatureParameter> arguments;
    public static final int VARCHAR_UNBOUNDED_LENGTH = Integer.MAX_VALUE;

    public ClientTypeSignature(String rawType) {
        this(rawType, (List<ClientTypeSignatureParameter>)ImmutableList.of());
    }

    @JsonCreator
    public ClientTypeSignature(@JsonProperty(value="rawType") String rawType, @JsonProperty(value="arguments") List<ClientTypeSignatureParameter> arguments) {
        Objects.requireNonNull(rawType, "rawType is null");
        this.rawType = rawType;
        Preconditions.checkArgument((!rawType.isEmpty() ? 1 : 0) != 0, (Object)"rawType is empty");
        Preconditions.checkArgument((!PATTERN.matcher(rawType).matches() ? 1 : 0) != 0, (String)"Bad characters in rawType type: %s", (Object)rawType);
        this.arguments = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(arguments, "arguments is null")));
    }

    @JsonProperty
    public String getRawType() {
        return this.rawType;
    }

    @JsonProperty
    public List<ClientTypeSignatureParameter> getArguments() {
        return this.arguments;
    }

    public List<ClientTypeSignature> getArgumentsAsTypeSignatures() {
        return (List)this.arguments.stream().peek(parameter -> Preconditions.checkState((parameter.getKind() == ClientTypeSignatureParameter.ParameterKind.TYPE ? 1 : 0) != 0, (String)"Expected all parameters to be TypeSignatures but [%s] was found", (Object)parameter)).map(ClientTypeSignatureParameter::getTypeSignature).collect(ImmutableList.toImmutableList());
    }

    public String toString() {
        if (this.rawType.equals("row")) {
            return this.rowToString();
        }
        if (this.rawType.equals("varchar") && this.arguments.get(0).getKind() == ClientTypeSignatureParameter.ParameterKind.LONG && this.arguments.get(0).getLongLiteral() == Integer.MAX_VALUE) {
            return "varchar";
        }
        if (this.arguments.isEmpty()) {
            return this.rawType;
        }
        return this.rawType + this.arguments.stream().map(ClientTypeSignatureParameter::toString).collect(Collectors.joining(",", "(", ")"));
    }

    @Deprecated
    private String rowToString() {
        if (this.arguments.isEmpty()) {
            return "row";
        }
        return this.arguments.stream().map(ClientTypeSignatureParameter::getNamedTypeSignature).map(parameter -> {
            if (parameter.getName().isPresent()) {
                return parameter.getName().get() + " " + parameter.getTypeSignature();
            }
            return parameter.getTypeSignature().toString();
        }).collect(Collectors.joining(",", "row(", ")"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTypeSignature other = (ClientTypeSignature)o;
        return Objects.equals(this.rawType.toLowerCase(Locale.ENGLISH), other.rawType.toLowerCase(Locale.ENGLISH)) && Objects.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.rawType.toLowerCase(Locale.ENGLISH), this.arguments);
    }
}

