/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableList;
import com.opencsv.CSVWriter;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import io.trino.cli.FormatUtils;
import io.trino.cli.OutputPrinter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;

public class CsvPrinter
implements OutputPrinter {
    private final List<String> fieldNames;
    private final ICSVWriter writer;
    private boolean needHeader;

    public CsvPrinter(List<String> fieldNames, Writer writer, CsvOutputFormat csvOutputFormat) {
        Objects.requireNonNull(fieldNames, "fieldNames is null");
        Objects.requireNonNull(writer, "writer is null");
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.writer = csvOutputFormat.isQuoted() ? new CSVWriter(writer) : new CSVWriterBuilder(writer).withQuoteChar('\u0000').withEscapeChar('\u0000').build();
        this.needHeader = csvOutputFormat.showHeader();
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        String[] array = null;
        if (this.needHeader) {
            this.needHeader = false;
            array = CsvPrinter.toStrings(this.fieldNames, array);
            this.writer.writeNext(array);
        }
        for (List<?> row : rows) {
            array = CsvPrinter.toStrings(row, array);
            this.writer.writeNext(array);
            this.checkError();
        }
    }

    @Override
    public void finish() throws IOException {
        this.printRows((List<List<?>>)ImmutableList.of(), true);
        this.writer.flush();
        this.checkError();
    }

    private void checkError() throws IOException {
        if (this.writer.checkError()) {
            throw new IOException("error writing to output");
        }
    }

    private static String[] toStrings(List<?> values, String[] array) {
        int rowSize = values.size();
        if (array == null || rowSize != array.length) {
            array = new String[rowSize];
        }
        for (int i = 0; i < rowSize; ++i) {
            array[i] = FormatUtils.formatValue(values.get(i), "", -1);
        }
        return array;
    }

    public static enum CsvOutputFormat {
        STANDARD(true, true),
        NO_HEADER(false, true),
        NO_QUOTES(true, false),
        NO_HEADER_AND_QUOTES(false, false);

        private final boolean header;
        private final boolean quote;

        private CsvOutputFormat(boolean header, boolean quote) {
            this.header = header;
            this.quote = quote;
        }

        public boolean showHeader() {
            return this.header;
        }

        public boolean isQuoted() {
            return this.quote;
        }
    }
}

