/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import picocli.CommandLine;

public class ValidatingPropertiesDefaultProvider
extends CommandLine.PropertiesDefaultProvider {
    protected ValidatingPropertiesDefaultProvider(File configFile) {
        super(configFile);
    }

    public static void attach(CommandLine commandLine, File configFile) {
        ValidatingPropertiesDefaultProvider.validateConfigurationProperties(commandLine.getCommandSpec(), configFile.getPath());
        commandLine.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new ValidatingPropertiesDefaultProvider(configFile));
    }

    private static void validateConfigurationProperties(CommandLine.Model.CommandSpec commandSpec, String path) {
        CharMatcher isDash = CharMatcher.is((char)'-');
        try (InputStream inputStream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(inputStream);
            Set<String> definedOptions = properties.stringPropertyNames();
            Set knownOptions = (Set)commandSpec.args().stream().flatMap(ValidatingPropertiesDefaultProvider::getOptionNamesFromSpec).map(arg_0 -> ((CharMatcher)isDash).trimLeadingFrom(arg_0)).collect(ImmutableSet.toImmutableSet());
            Sets.SetView unknownOptions = Sets.difference(definedOptions, (Set)knownOptions);
            if (!unknownOptions.isEmpty()) {
                System.err.printf("Configuration file %s contains unknown properties %s\n", path, unknownOptions);
                System.exit(1);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Stream<String> getOptionNames(CommandLine.Model.OptionSpec optionSpec) {
        if (optionSpec.usageHelp() || optionSpec.versionHelp()) {
            return Stream.empty();
        }
        return ImmutableList.copyOf((Object[])optionSpec.names()).stream();
    }

    private static Stream<String> getOptionNamesFromSpec(CommandLine.Model.ArgSpec argSpec) {
        if (argSpec instanceof CommandLine.Model.OptionSpec) {
            return ValidatingPropertiesDefaultProvider.getOptionNames((CommandLine.Model.OptionSpec)argSpec);
        }
        if (argSpec instanceof CommandLine.Model.PositionalParamSpec) {
            return ValidatingPropertiesDefaultProvider.getOptionNames((CommandLine.Model.PositionalParamSpec)argSpec);
        }
        throw new RuntimeException("Unknown option " + String.valueOf(argSpec));
    }

    private static Stream<String> getOptionNames(CommandLine.Model.PositionalParamSpec paramSpec) {
        return ImmutableList.of((Object)paramSpec.paramLabel()).stream();
    }
}

