/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.client.Row;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class FormatUtils {
    private static final Splitter HEX_SPLITTER = Splitter.fixedLength((int)2);
    private static final Joiner HEX_BYTE_JOINER = Joiner.on((char)' ');
    private static final Joiner HEX_LINE_JOINER = Joiner.on((char)'\n');

    private FormatUtils() {
    }

    public static String formatCount(long count) {
        double fractional = count;
        String unit = "";
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "K";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "M";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "B";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "T";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "Q";
        }
        return String.format("%s%s", FormatUtils.getFormat(fractional).format(fractional), unit);
    }

    public static String formatCountRate(double count, Duration duration, boolean longForm) {
        double rate = count / duration.getValue(TimeUnit.SECONDS);
        if (Double.isNaN(rate) || Double.isInfinite(rate)) {
            rate = 0.0;
        }
        Object rateString = FormatUtils.formatCount((long)rate);
        if (longForm) {
            if (((String)rateString).endsWith(" ")) {
                rateString = ((String)rateString).substring(0, ((String)rateString).length() - 1);
            }
            rateString = (String)rateString + "/s";
        }
        return rateString;
    }

    public static String formatDataSize(DataSize size, boolean longForm, boolean decimalDataSize) {
        int divisor = decimalDataSize ? 1000 : 1024;
        double fractional = size.toBytes();
        Object unit = null;
        if (fractional >= (double)divisor) {
            fractional /= (double)divisor;
            unit = "K";
        }
        if (fractional >= (double)divisor) {
            fractional /= (double)divisor;
            unit = "M";
        }
        if (fractional >= (double)divisor) {
            fractional /= (double)divisor;
            unit = "G";
        }
        if (fractional >= (double)divisor) {
            fractional /= (double)divisor;
            unit = "T";
        }
        if (fractional >= (double)divisor) {
            fractional /= (double)divisor;
            unit = "P";
        }
        if (unit == null) {
            unit = "B";
        } else {
            if (!decimalDataSize) {
                unit = (String)unit + "i";
            }
            if (longForm) {
                unit = (String)unit + "B";
            }
        }
        return String.format("%s%s", FormatUtils.getFormat(fractional).format(fractional), unit);
    }

    public static String formatDataRate(DataSize dataSize, Duration duration, boolean longForm, boolean decimalDataSize) {
        long rate = Math.round((double)dataSize.toBytes() / duration.getValue(TimeUnit.SECONDS));
        if (rate == Long.MAX_VALUE) {
            rate = 0L;
        }
        Object rateString = FormatUtils.formatDataSize(DataSize.ofBytes((long)rate), false, decimalDataSize);
        if (longForm) {
            if (!((String)rateString).endsWith("B")) {
                rateString = (String)rateString + "B";
            }
            rateString = (String)rateString + "/s";
        }
        return rateString;
    }

    private static DecimalFormat getFormat(double value) {
        DecimalFormat format = value < 10.0 ? new DecimalFormat("#.##") : (value < 100.0 ? new DecimalFormat("#.#") : new DecimalFormat("#"));
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format;
    }

    public static String pluralize(String word, int count) {
        if (count != 1) {
            return word + "s";
        }
        return word;
    }

    public static String formatTime(Duration duration) {
        int totalSeconds = Ints.saturatedCast((long)duration.roundTo(TimeUnit.SECONDS));
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%s:%02d", minutes, seconds);
    }

    public static String formatFinalTime(Duration duration) {
        long totalMillis = duration.toMillis();
        if (totalMillis >= TimeUnit.MINUTES.toMillis(1L)) {
            return FormatUtils.formatTime(duration);
        }
        return String.format("%.2f", (double)totalMillis / 1000.0);
    }

    public static String formatProgressBar(int width, int tick) {
        int markerWidth = 3;
        int range = width - markerWidth;
        int lower = tick % range;
        if (tick / range % 2 == 1) {
            lower = range - lower;
        }
        return Strings.repeat((String)" ", (int)lower) + "<" + Strings.repeat((String)"=", (int)(markerWidth - 2)) + ">" + Strings.repeat((String)" ", (int)(width - (lower + markerWidth)));
    }

    public static String formatProgressBar(int width, int progressPercentage, int runningPercentage) {
        int totalPercentage = 100;
        int pending = Math.max(0, totalPercentage - progressPercentage - runningPercentage);
        int completeLength = Math.min(width, FormatUtils.ceil(progressPercentage * width, totalPercentage));
        int pendingLength = Math.min(width, FormatUtils.ceil(pending * width, totalPercentage));
        int minRunningLength = runningPercentage > 0 ? 1 : 0;
        int runningLength = Math.max(Math.min(width, FormatUtils.ceil(runningPercentage * width, totalPercentage)), minRunningLength);
        if (completeLength + runningLength + pendingLength != width && pending > 0) {
            pendingLength = Math.max(0, width - completeLength - runningLength);
        }
        if (completeLength + runningLength + pendingLength != width) {
            runningLength = Math.max(minRunningLength, width - completeLength - pendingLength);
        }
        if (completeLength + runningLength + pendingLength > width && progressPercentage > 0) {
            completeLength = Math.max(0, width - runningLength - pendingLength);
        }
        Preconditions.checkState((completeLength + runningLength + pendingLength == width ? 1 : 0) != 0, (String)"Expected completeLength (%s) + runningLength (%s) + pendingLength (%s) == width (%s), was %s for progressPercentage = %s, runningPercentage = %s, totalPercentage = %s", (Object[])new Object[]{completeLength, runningLength, pendingLength, width, completeLength + runningLength + pendingLength, progressPercentage, runningPercentage, totalPercentage});
        return Strings.repeat((String)"=", (int)completeLength) + Strings.repeat((String)">", (int)runningLength) + Strings.repeat((String)" ", (int)pendingLength);
    }

    private static int ceil(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }

    static String formatValue(Object o) {
        return FormatUtils.formatValue(o, "NULL", 16);
    }

    static String formatValue(Object o, String nullValue, int bytesPerLine) {
        if (o == null) {
            return nullValue;
        }
        if (o instanceof Map) {
            return FormatUtils.formatMap((Map)o);
        }
        if (o instanceof List) {
            return FormatUtils.formatList((List)o);
        }
        if (o instanceof Row) {
            return FormatUtils.formatRow((Row)o);
        }
        if (o instanceof byte[]) {
            return FormatUtils.formatHexDump((byte[])o, bytesPerLine);
        }
        return o.toString();
    }

    private static String formatHexDump(byte[] bytes, int bytesPerLine) {
        if (bytesPerLine <= 0) {
            return FormatUtils.formatHexDump(bytes);
        }
        Iterable<String> hexPairs = FormatUtils.createHexPairs(bytes);
        Iterable hexLines = Iterables.partition(hexPairs, (int)bytesPerLine);
        Iterable lines = Iterables.transform((Iterable)hexLines, arg_0 -> ((Joiner)HEX_BYTE_JOINER).join(arg_0));
        return HEX_LINE_JOINER.join(lines);
    }

    static String formatHexDump(byte[] bytes) {
        return HEX_BYTE_JOINER.join(FormatUtils.createHexPairs(bytes));
    }

    private static Iterable<String> createHexPairs(byte[] bytes) {
        String hexDump = BaseEncoding.base16().lowerCase().encode(bytes);
        return HEX_SPLITTER.split((CharSequence)hexDump);
    }

    static String formatList(List<? extends Object> list) {
        return list.stream().map(FormatUtils::formatValue).collect(Collectors.joining(", ", "[", "]"));
    }

    static String formatMap(Map<? extends Object, ? extends Object> map) {
        return map.entrySet().stream().map(entry -> String.format("%s=%s", FormatUtils.formatValue(entry.getKey()), FormatUtils.formatValue(entry.getValue()))).collect(Collectors.joining(", ", "{", "}"));
    }

    static String formatRow(Row row) {
        return row.getFields().stream().map(field -> {
            String formattedValue = FormatUtils.formatValue(field.getValue());
            if (field.getName().isPresent()) {
                return String.format("%s=%s", FormatUtils.formatValue(field.getName().get()), formattedValue);
            }
            return formattedValue;
        }).collect(Collectors.joining(", ", "{", "}"));
    }
}

