/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.cli.AbstractWarningsPrinter;
import io.trino.cli.ConsolePrinter;
import io.trino.cli.FormatUtils;
import io.trino.cli.TerminalUtils;
import io.trino.cli.WarningsPrinter;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StageStats;
import io.trino.client.StatementClient;
import io.trino.client.StatementStats;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;

public class StatusPrinter {
    private static final int CTRL_C = 3;
    private static final int CTRL_P = 16;
    private final long start = System.nanoTime();
    private final StatementClient client;
    private final PrintStream out;
    private final ConsolePrinter console;
    private final boolean checkInput;
    private boolean debug;
    private boolean decimalDataSize;

    public StatusPrinter(StatementClient client, PrintStream out, boolean debug, boolean checkInput, boolean decimalDataSize) {
        this.client = client;
        this.out = out;
        this.console = new ConsolePrinter(out);
        this.debug = debug;
        this.checkInput = checkInput;
        this.decimalDataSize = decimalDataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printInitialStatusUpdates(Terminal terminal) {
        Attributes originalAttributes = terminal.enterRawMode();
        long start = System.nanoTime();
        long lastPrint = System.nanoTime();
        try {
            ConsoleWarningsPrinter warningsPrinter = new ConsoleWarningsPrinter(this.console);
            while (this.client.isRunning()) {
                block16: {
                    if (this.client.currentData().getData() == null) break block16;
                    return;
                }
                try {
                    boolean update;
                    boolean bl = update = Duration.nanosSince((long)lastPrint).getValue(TimeUnit.SECONDS) >= 0.5;
                    if (this.checkInput && Duration.nanosSince((long)start).getValue(TimeUnit.SECONDS) >= 0.3) {
                        int key = StatusPrinter.readKey(terminal);
                        if (key == 16) {
                            this.client.cancelLeafStage();
                        } else if (key == 3) {
                            this.updateScreen(warningsPrinter);
                            update = false;
                            this.client.close();
                        } else if (Character.toUpperCase(key) == 68) {
                            this.debug = !this.debug;
                            this.console.resetScreen();
                            update = true;
                        }
                    }
                    if (update) {
                        this.updateScreen(warningsPrinter);
                        lastPrint = System.nanoTime();
                    }
                    this.client.advance();
                }
                catch (RuntimeException e) {
                    if (!this.debug) continue;
                    e.printStackTrace(this.out);
                }
            }
        }
        finally {
            this.console.resetScreen();
            if (this.checkInput) {
                StatusPrinter.discardKeys(terminal);
            }
            terminal.setAttributes(originalAttributes);
        }
    }

    private void updateScreen(WarningsPrinter warningsPrinter) {
        this.console.repositionCursor();
        this.printQueryInfo(this.client.currentStatusInfo(), warningsPrinter);
    }

    public void printFinalInfo() {
        QueryStatusInfo results = this.client.finalStatusInfo();
        StatementStats stats = results.getStats();
        Duration wallTime = Duration.succinctDuration((double)stats.getElapsedTimeMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        int nodes = stats.getNodes();
        if (nodes == 0 || stats.getTotalSplits() == 0) {
            return;
        }
        this.out.println();
        String querySummary = String.format("Query %s, %s, %,d %s", results.getId(), stats.getState(), nodes, FormatUtils.pluralize("node", nodes));
        this.out.println(querySummary);
        if (this.debug) {
            this.out.println(results.getInfoUri().toString());
        }
        String splitsSummary = String.format("Splits: %,d total, %,d done (%.2f%%)", stats.getTotalSplits(), stats.getCompletedSplits(), stats.getProgressPercentage().orElse(0.0));
        this.out.println(splitsSummary);
        if (this.debug) {
            Duration cpuTime = StatusPrinter.millis(stats.getCpuTimeMillis());
            String cpuTimeSummary = String.format("CPU Time: %.1fs total, %5s rows/s, %8s, %d%% active", cpuTime.getValue(TimeUnit.SECONDS), FormatUtils.formatCountRate(stats.getProcessedRows(), cpuTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), cpuTime, true, this.decimalDataSize), (int)StatusPrinter.percentage(stats.getCpuTimeMillis(), stats.getWallTimeMillis()));
            this.out.println(cpuTimeSummary);
            double parallelism = cpuTime.getValue(TimeUnit.MILLISECONDS) / wallTime.getValue(TimeUnit.MILLISECONDS);
            String perNodeSummary = String.format("Per Node: %.1f parallelism, %5s rows/s, %8s", parallelism / (double)nodes, FormatUtils.formatCountRate((double)stats.getProcessedRows() / (double)nodes, wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes() / (long)nodes), wallTime, true, this.decimalDataSize));
            this.reprintLine(perNodeSummary);
            this.out.println(String.format("Parallelism: %.1f", parallelism));
            this.reprintLine("Peak Memory: " + FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getPeakMemoryBytes()), true, this.decimalDataSize));
            if (stats.getSpilledBytes() > 0L) {
                this.reprintLine("Spilled: " + FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getSpilledBytes()), true, this.decimalDataSize));
            }
        }
        String statsLine = String.format("%s [%s rows, %s] [%s rows/s, %s]", FormatUtils.formatFinalTime(wallTime), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), true, this.decimalDataSize), FormatUtils.formatCountRate(stats.getProcessedRows(), wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, true, this.decimalDataSize));
        this.out.println(statsLine);
        this.out.println();
    }

    private void printQueryInfo(QueryStatusInfo results, WarningsPrinter warningsPrinter) {
        StatementStats stats = results.getStats();
        Duration wallTime = Duration.nanosSince((long)this.start);
        int progressPercentage = (int)Math.min(99.0, stats.getProgressPercentage().orElse(0.0));
        if (TerminalUtils.isRealTerminal()) {
            String progressLine;
            String progressBar;
            this.reprintLine("");
            int terminalWidth = TerminalUtils.terminalWidth();
            if (terminalWidth < 75) {
                this.reprintLine("WARNING: Terminal");
                this.reprintLine("must be at least");
                this.reprintLine("80 characters wide");
                this.reprintLine("");
                this.reprintLine(stats.getState());
                this.reprintLine(String.format("%s %d%%", FormatUtils.formatTime(wallTime), progressPercentage));
                return;
            }
            int nodes = stats.getNodes();
            String querySummary = String.format("Query %s, %s, %,d %s, %,d splits", results.getId(), stats.getState(), nodes, FormatUtils.pluralize("node", nodes), stats.getTotalSplits());
            this.reprintLine(querySummary);
            String url = results.getInfoUri().toString();
            if (this.debug && url.length() < terminalWidth) {
                this.reprintLine(url);
            }
            if (nodes == 0 || stats.getTotalSplits() == 0) {
                return;
            }
            if (this.debug) {
                String splitsSummary = String.format("Splits:   %,d queued, %,d running, %,d done", stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits());
                this.reprintLine(splitsSummary);
                Duration cpuTime = StatusPrinter.millis(stats.getCpuTimeMillis());
                String cpuTimeSummary = String.format("CPU Time: %.1fs total, %5s rows/s, %8s, %d%% active", cpuTime.getValue(TimeUnit.SECONDS), FormatUtils.formatCountRate(stats.getProcessedRows(), cpuTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), cpuTime, true, this.decimalDataSize), (int)StatusPrinter.percentage(stats.getCpuTimeMillis(), stats.getWallTimeMillis()));
                this.reprintLine(cpuTimeSummary);
                double parallelism = cpuTime.getValue(TimeUnit.MILLISECONDS) / wallTime.getValue(TimeUnit.MILLISECONDS);
                String perNodeSummary = String.format("Per Node: %.1f parallelism, %5s rows/s, %8s", parallelism / (double)nodes, FormatUtils.formatCountRate((double)stats.getProcessedRows() / (double)nodes, wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes() / (long)nodes), wallTime, true, this.decimalDataSize));
                this.reprintLine(perNodeSummary);
                this.reprintLine(String.format("Parallelism: %.1f", parallelism));
                this.reprintLine("Peak Memory: " + FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getPeakMemoryBytes()), true, this.decimalDataSize));
                if (stats.getSpilledBytes() > 0L) {
                    this.reprintLine("Spilled: " + FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getSpilledBytes()), true, this.decimalDataSize));
                }
            }
            Verify.verify((terminalWidth >= 75 ? 1 : 0) != 0);
            int progressWidth = Math.min(terminalWidth, 100) - 75 + 17;
            if (stats.isScheduled()) {
                progressBar = FormatUtils.formatProgressBar(progressWidth, progressPercentage, (int)Math.ceil(stats.getRunningPercentage().orElse(0.0)));
                progressLine = String.format("%s [%5s rows, %6s] [%5s rows/s, %8s] [%s] %d%%", FormatUtils.formatTime(wallTime), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), true, this.decimalDataSize), FormatUtils.formatCountRate(stats.getProcessedRows(), wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, true, this.decimalDataSize), progressBar, progressPercentage);
                this.reprintLine(progressLine);
            } else {
                progressBar = FormatUtils.formatProgressBar(progressWidth, Ints.saturatedCast((long)Duration.nanosSince((long)this.start).roundTo(TimeUnit.SECONDS)));
                progressLine = String.format("%s [%5s rows, %6s] [%5s rows/s, %8s] [%s]", FormatUtils.formatTime(wallTime), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), true, this.decimalDataSize), FormatUtils.formatCountRate(stats.getProcessedRows(), wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, true, this.decimalDataSize), progressBar);
                this.reprintLine(progressLine);
            }
            this.reprintLine("");
            String stagesHeader = String.format("%10s%1s  %5s  %6s  %5s  %7s  %6s  %5s  %5s", "STAGE", "S", "ROWS", "ROWS/s", "BYTES", "BYTES/s", "QUEUED", "RUN", "DONE");
            this.reprintLine(stagesHeader);
            this.printStageTree(stats.getRootStage(), "", new AtomicInteger());
        } else {
            String querySummary = String.format("Query %s [%s] i[%s %s %s] o[%s %s %s] splits[%,d/%,d/%,d]", results.getId(), stats.getState(), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), false, this.decimalDataSize), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, false, this.decimalDataSize), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), false, this.decimalDataSize), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, false, this.decimalDataSize), stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits());
            this.reprintLine(querySummary);
        }
        warningsPrinter.print(results.getWarnings(), true, false);
    }

    private void printStageTree(StageStats stage, String indent, AtomicInteger stageNumberCounter) {
        String rowsPerSecond;
        String bytesPerSecond;
        Duration elapsedTime = Duration.nanosSince((long)this.start);
        String id = String.valueOf(stageNumberCounter.getAndIncrement());
        String name = indent + id;
        name = name + Strings.repeat((String)".", (int)Math.max(0, 10 - name.length()));
        if (stage.isDone()) {
            bytesPerSecond = FormatUtils.formatDataRate(DataSize.ofBytes((long)0L), new Duration(0.0, TimeUnit.SECONDS), false, this.decimalDataSize);
            rowsPerSecond = FormatUtils.formatCountRate(0.0, new Duration(0.0, TimeUnit.SECONDS), false);
        } else {
            bytesPerSecond = FormatUtils.formatDataRate(StatusPrinter.bytes(stage.getProcessedBytes()), elapsedTime, false, this.decimalDataSize);
            rowsPerSecond = FormatUtils.formatCountRate(stage.getProcessedRows(), elapsedTime, false);
        }
        String stageSummary = String.format("%10s%1s  %5s  %6s  %5s  %7s  %6s  %5s  %5s", name, Character.valueOf(StatusPrinter.stageStateCharacter(stage.getState())), FormatUtils.formatCount(stage.getProcessedRows()), rowsPerSecond, FormatUtils.formatDataSize(StatusPrinter.bytes(stage.getProcessedBytes()), false, this.decimalDataSize), bytesPerSecond, stage.getQueuedSplits(), stage.getRunningSplits(), stage.getCompletedSplits());
        this.reprintLine(stageSummary);
        for (StageStats subStage : stage.getSubStages()) {
            this.printStageTree(subStage, indent + "  ", stageNumberCounter);
        }
    }

    private void reprintLine(String line) {
        this.console.reprintLine(line);
    }

    private static int readKey(Terminal terminal) {
        try {
            return terminal.reader().read(1L);
        }
        catch (IOException e) {
            return -1;
        }
    }

    private static void discardKeys(Terminal terminal) {
        while (StatusPrinter.readKey(terminal) >= 0) {
        }
    }

    private static char stageStateCharacter(String state) {
        return "FAILED".equals(state) ? (char)'X' : state.charAt(0);
    }

    private static Duration millis(long millis) {
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }

    private static DataSize bytes(long bytes) {
        return DataSize.ofBytes((long)bytes);
    }

    private static double percentage(double count, double total) {
        if (total == 0.0) {
            return 0.0;
        }
        return Math.min(100.0, count * 100.0 / total);
    }

    private static class ConsoleWarningsPrinter
    extends AbstractWarningsPrinter {
        private static final int DISPLAYED_WARNINGS = 5;
        private final ConsolePrinter console;

        ConsoleWarningsPrinter(ConsolePrinter console) {
            super(OptionalInt.of(5));
            this.console = Objects.requireNonNull(console, "console is null");
        }

        @Override
        protected void print(List<String> warnings) {
            for (String warning : warnings) {
                this.console.reprintLine(warning);
            }
        }

        @Override
        protected void printSeparator() {
            this.console.reprintLine("");
        }
    }
}

