/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.trino.cli.QueryRunner;
import io.trino.client.QueryData;
import io.trino.client.StatementClient;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class TableNameCompleter
implements Completer,
Closeable {
    private static final long RELOAD_TIME_MINUTES = 2L;
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("completer-%s").setDaemon(true).build());
    private final QueryRunner queryRunner;
    private final LoadingCache<String, List<String>> tableCache;
    private final LoadingCache<String, List<String>> functionCache;

    public TableNameCompleter(QueryRunner queryRunner) {
        this.queryRunner = Objects.requireNonNull(queryRunner, "queryRunner session was null!");
        this.tableCache = TableNameCompleter.buildUnsafeCache(CacheBuilder.newBuilder().refreshAfterWrite(2L, TimeUnit.MINUTES), CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::listTables), (Executor)this.executor));
        this.functionCache = TableNameCompleter.buildUnsafeCache(CacheBuilder.newBuilder(), CacheLoader.from(this::listFunctions));
    }

    @SuppressModernizer
    private static <K, V> LoadingCache<K, V> buildUnsafeCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        return cacheBuilder.build(cacheLoader);
    }

    private List<String> listTables(String schemaName) {
        return this.queryMetadata(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", schemaName));
    }

    private List<String> listFunctions(String schemaName) {
        return this.queryMetadata("SHOW FUNCTIONS");
    }

    private List<String> queryMetadata(String query) {
        ImmutableList.Builder cache = ImmutableList.builder();
        try (StatementClient client = this.queryRunner.startInternalQuery(query);){
            while (client.isRunning() && !Thread.currentThread().isInterrupted()) {
                QueryData results = client.currentData();
                if (results.getData() != null) {
                    for (List row : results.getData()) {
                        cache.add((Object)((String)row.get(0)));
                    }
                }
                client.advance();
            }
        }
        return cache.build();
    }

    public void populateCache() {
        String schemaName = this.queryRunner.getSession().getSchema();
        if (schemaName != null) {
            this.executor.execute(() -> {
                this.functionCache.refresh((Object)schemaName);
                this.tableCache.refresh((Object)schemaName);
            });
        }
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        String buffer = line.word().substring(0, line.wordCursor());
        int blankPos = TableNameCompleter.findLastBlank(buffer);
        String prefix = buffer.substring(blankPos + 1);
        String schemaName = this.queryRunner.getSession().getSchema();
        if (schemaName != null) {
            List functionNames = (List)this.functionCache.getIfPresent((Object)schemaName);
            List tableNames = (List)this.tableCache.getIfPresent((Object)schemaName);
            if (functionNames != null) {
                for (String name : TableNameCompleter.filterResults(functionNames, prefix)) {
                    candidates.add(new Candidate(name));
                }
            }
            if (tableNames != null) {
                for (String name : TableNameCompleter.filterResults(tableNames, prefix)) {
                    candidates.add(new Candidate(name));
                }
            }
        }
    }

    private static int findLastBlank(String buffer) {
        for (int i = buffer.length() - 1; i >= 0; --i) {
            if (!Character.isWhitespace(buffer.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static List<String> filterResults(List<String> values, String prefix) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String value : values) {
            if (!value.startsWith(prefix)) continue;
            builder.add((Object)value);
        }
        return builder.build();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

