/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.collect.ImmutableSet;
import io.trino.cli.Console;
import io.trino.sql.ReservedIdentifiers;
import io.trino.sql.parser.StatementSplitter;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class InputHighlighter
implements Highlighter {
    private static final AttributedStyle KEYWORD_STYLE = AttributedStyle.BOLD;
    private static final AttributedStyle STRING_STYLE = AttributedStyle.DEFAULT.foreground(2);
    private static final AttributedStyle NUMBER_STYLE = AttributedStyle.DEFAULT.foreground(6);
    private static final AttributedStyle COMMENT_STYLE = AttributedStyle.DEFAULT.foreground(8).italic();
    private static final AttributedStyle ERROR_STYLE = AttributedStyle.DEFAULT.foreground(1);
    private static final Set<String> KEYWORDS = (Set)ReservedIdentifiers.sqlKeywords().stream().map(keyword -> keyword.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());

    public AttributedString highlight(LineReader reader, String buffer) {
        Token token;
        int type;
        TokenSource tokens = StatementSplitter.getLexer((String)buffer, Console.STATEMENT_DELIMITERS);
        AttributedStringBuilder builder = new AttributedStringBuilder();
        boolean error = false;
        while ((type = (token = tokens.nextToken()).getType()) != -1) {
            String text = token.getText();
            if (error || type == 318) {
                error = true;
                builder.styled(ERROR_STYLE, (CharSequence)text);
                continue;
            }
            if (InputHighlighter.isKeyword(text)) {
                builder.styled(KEYWORD_STYLE, (CharSequence)text);
                continue;
            }
            if (InputHighlighter.isString(type)) {
                builder.styled(STRING_STYLE, (CharSequence)text);
                continue;
            }
            if (InputHighlighter.isNumber(type)) {
                builder.styled(NUMBER_STYLE, (CharSequence)text);
                continue;
            }
            if (InputHighlighter.isComment(type)) {
                builder.styled(COMMENT_STYLE, (CharSequence)text);
                continue;
            }
            builder.append((CharSequence)text);
        }
        return builder.toAttributedString();
    }

    public void setErrorPattern(Pattern pattern) {
    }

    public void setErrorIndex(int i) {
    }

    private static boolean isKeyword(String text) {
        return KEYWORDS.contains(text.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isString(int type) {
        return type == 305 || type == 306 || type == 307;
    }

    private static boolean isNumber(int type) {
        return type == 308 || type == 310 || type == 309;
    }

    private static boolean isComment(int type) {
        return type == 315 || type == 316;
    }
}

