/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.MoreObjects;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.cli.ClientOptions;
import io.trino.cli.Console;
import picocli.CommandLine;

public final class Trino {
    private Trino() {
    }

    public static void main(String[] args) {
        System.exit(Trino.createCommandLine(new Console()).execute(args));
    }

    public static CommandLine createCommandLine(Object command) {
        return new CommandLine(command).registerConverter(ClientOptions.ClientResourceEstimate.class, ClientOptions.ClientResourceEstimate::new).registerConverter(ClientOptions.ClientSessionProperty.class, ClientOptions.ClientSessionProperty::new).registerConverter(ClientOptions.ClientExtraCredential.class, ClientOptions.ClientExtraCredential::new).registerConverter(HostAndPort.class, HostAndPort::fromString).registerConverter(Duration.class, Duration::valueOf);
    }

    public static class VersionProvider
    implements CommandLine.IVersionProvider {
        public String[] getVersion() {
            String version = this.getClass().getPackage().getImplementationVersion();
            return new String[]{"Trino CLI " + (String)MoreObjects.firstNonNull((Object)version, (Object)"(version unknown)")};
        }
    }
}

