/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.BigQueryOptionsConfigurer;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;

public class CredentialsOptionsConfigurer
implements BigQueryOptionsConfigurer {
    private final BigQueryCredentialsSupplier credentialsSupplier;
    private final Optional<String> parentProjectId;

    @Inject
    public CredentialsOptionsConfigurer(BigQueryConfig bigQueryConfig, BigQueryCredentialsSupplier credentialsSupplier) {
        this.parentProjectId = Objects.requireNonNull(bigQueryConfig, "bigQueryConfig is null").getParentProjectId();
        this.credentialsSupplier = Objects.requireNonNull(credentialsSupplier, "credentialsSupplier is null");
    }

    @Override
    public BigQueryOptions.Builder configure(BigQueryOptions.Builder builder, ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        String billingProjectId = CredentialsOptionsConfigurer.calculateBillingProjectId(this.parentProjectId, credentials);
        credentials.ifPresent(arg_0 -> ((BigQueryOptions.Builder)builder).setCredentials(arg_0));
        builder.setProjectId(billingProjectId);
        return builder;
    }

    @Override
    public BigQueryReadSettings.Builder configure(BigQueryReadSettings.Builder builder, ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        credentials.ifPresent(value -> builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)value)));
        return builder;
    }

    @VisibleForTesting
    static String calculateBillingProjectId(Optional<String> configParentProjectId, Optional<Credentials> credentials) {
        return configParentProjectId.orElseGet(() -> credentials.filter(ServiceAccountCredentials.class::isInstance).map(ServiceAccountCredentials.class::cast).map(ServiceAccountCredentials::getProjectId).orElseGet(ServiceOptions::getDefaultProjectId));
    }
}

