/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.common.base.MoreObjects;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryType;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class Conversions {
    private Conversions() {
    }

    public static BigQueryColumnHandle toColumnHandle(Field field) {
        FieldList subFields = field.getSubFields();
        List<BigQueryColumnHandle> subColumns = subFields == null ? Collections.emptyList() : subFields.stream().filter(Conversions::isSupportedType).map(Conversions::toColumnHandle).collect(Collectors.toList());
        return new BigQueryColumnHandle(field.getName(), BigQueryType.toTrinoType(field).orElseThrow(() -> new IllegalArgumentException("Unsupported type: " + field)), field.getType().getStandardType(), Conversions.getMode(field), field.getPrecision(), field.getScale(), subColumns, field.getDescription(), false);
    }

    public static boolean isSupportedType(Field field) {
        LegacySQLTypeName type = field.getType();
        if (type == LegacySQLTypeName.BIGNUMERIC) {
            if (field.getPrecision() == null && field.getScale() == null) {
                return false;
            }
            if (field.getPrecision() != null && field.getPrecision() > 38L) {
                return false;
            }
        }
        return BigQueryType.toTrinoType(field).isPresent();
    }

    private static Field.Mode getMode(Field field) {
        return (Field.Mode)MoreObjects.firstNonNull((Object)field.getMode(), (Object)Field.Mode.NULLABLE);
    }
}

