/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import io.airlift.log.Logger;
import io.trino.plugin.bigquery.BigQueryArrowToPageConverter;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQuerySplit;
import io.trino.plugin.bigquery.ReadRowsHelper;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;

public class BigQueryStorageArrowPageSource
implements ConnectorPageSource {
    private static final Logger log = Logger.get(BigQueryStorageArrowPageSource.class);
    private static final BufferAllocator allocator = new RootAllocator((BaseAllocator.Config)RootAllocator.configBuilder().from(RootAllocator.defaultConfig()).maxAllocation(Integer.MAX_VALUE).build());
    private final AtomicLong readBytes = new AtomicLong();
    private final BigQueryReadClient bigQueryReadClient;
    private final BigQuerySplit split;
    private final Iterator<ReadRowsResponse> responses;
    private final BigQueryArrowToPageConverter bigQueryArrowToPageConverter;
    private final BufferAllocator streamBufferAllocator;
    private final PageBuilder pageBuilder;

    public BigQueryStorageArrowPageSource(BigQueryReadClient bigQueryReadClient, int maxReadRowsRetries, BigQuerySplit split, List<BigQueryColumnHandle> columns) {
        this.bigQueryReadClient = Objects.requireNonNull(bigQueryReadClient, "bigQueryReadClient is null");
        this.split = Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(columns, "columns is null");
        Schema schema = BigQueryStorageArrowPageSource.deserializeSchema(split.getSchemaString());
        log.debug("Starting to read from %s", new Object[]{split.getStreamName()});
        this.responses = new ReadRowsHelper(bigQueryReadClient, split.getStreamName(), maxReadRowsRetries).readRows();
        this.streamBufferAllocator = allocator.newChildAllocator(split.getStreamName(), 1024L, Long.MAX_VALUE);
        this.bigQueryArrowToPageConverter = new BigQueryArrowToPageConverter(this.streamBufferAllocator, schema, columns);
        this.pageBuilder = new PageBuilder((List)columns.stream().map(BigQueryColumnHandle::getTrinoType).collect(ImmutableList.toImmutableList()));
    }

    public long getCompletedBytes() {
        return this.readBytes.get();
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return !this.responses.hasNext();
    }

    public Page getNextPage() {
        Preconditions.checkState((boolean)this.pageBuilder.isEmpty(), (Object)"PageBuilder is not empty at the beginning of a new page");
        if (!this.responses.hasNext()) {
            return null;
        }
        ReadRowsResponse response = this.responses.next();
        try (ArrowRecordBatch batch = this.deserializeResponse(this.streamBufferAllocator, response);){
            this.bigQueryArrowToPageConverter.convert(this.pageBuilder, batch);
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    public long getMemoryUsage() {
        long memoryUsage = this.streamBufferAllocator.getAllocatedMemory();
        if (this.split.getDataSize().isPresent()) {
            memoryUsage += (long)this.split.getDataSize().getAsInt() + this.pageBuilder.getSizeInBytes();
        }
        return memoryUsage;
    }

    public void close() {
        this.streamBufferAllocator.close();
        this.bigQueryArrowToPageConverter.close();
        this.bigQueryReadClient.close();
    }

    private ArrowRecordBatch deserializeResponse(BufferAllocator allocator, ReadRowsResponse response) {
        int serializedSize = response.getArrowRecordBatch().getSerializedSize();
        long totalReadSize = this.readBytes.addAndGet(serializedSize);
        log.debug("Read %d bytes (total %d) from %s", new Object[]{serializedSize, totalReadSize, this.split.getStreamName()});
        try {
            return MessageSerializer.deserializeRecordBatch((ReadChannel)BigQueryStorageArrowPageSource.readChannelForByteString(response.getArrowRecordBatch().getSerializedRecordBatch()), (BufferAllocator)allocator);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error deserializing next Arrow Batch", e);
        }
    }

    private static ReadChannel readChannelForByteString(ByteString input) {
        return new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(input.toByteArray()));
    }

    private static Schema deserializeSchema(String schema) {
        try {
            return Schema.fromJSON((String)schema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

