/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryQueryRelationHandle;
import io.trino.plugin.bigquery.BigQueryRelationHandle;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.BigQueryType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BigQueryQueryPageSource
implements ConnectorPageSource {
    private static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true).optionalEnd().toFormatter();
    private final List<Type> columnTypes;
    private final PageBuilder pageBuilder;
    private final TableResult tableResult;
    private boolean finished;

    public BigQueryQueryPageSource(ConnectorSession session, BigQueryClient client, BigQueryTableHandle table, List<String> columnNames, List<Type> columnTypes, Optional<String> filter) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Objects.requireNonNull(columnTypes, "columnTypes is null");
        Objects.requireNonNull(filter, "filter is null");
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes sizes don't match");
        this.columnTypes = ImmutableList.copyOf(columnTypes);
        this.pageBuilder = new PageBuilder(columnTypes);
        String sql = BigQueryQueryPageSource.buildSql(table, client.getProjectId(), (List<String>)ImmutableList.copyOf(columnNames), filter);
        this.tableResult = client.executeQuery(session, sql);
    }

    private static String buildSql(BigQueryTableHandle table, String projectId, List<String> columnNames, Optional<String> filter) {
        BigQueryRelationHandle bigQueryRelationHandle = table.getRelationHandle();
        if (bigQueryRelationHandle instanceof BigQueryQueryRelationHandle) {
            BigQueryQueryRelationHandle queryRelationHandle = (BigQueryQueryRelationHandle)bigQueryRelationHandle;
            if (filter.isEmpty()) {
                return queryRelationHandle.getQuery();
            }
            return "SELECT * FROM (" + queryRelationHandle.getQuery() + " ) WHERE " + filter.get();
        }
        TableId tableId = TableId.of((String)projectId, (String)table.asPlainTable().getRemoteTableName().getDatasetName(), (String)table.asPlainTable().getRemoteTableName().getTableName());
        return BigQueryClient.selectSql(tableId, (List<String>)ImmutableList.copyOf(columnNames), filter);
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public Page getNextPage() {
        Verify.verify((boolean)this.pageBuilder.isEmpty());
        for (FieldValueList record : this.tableResult.iterateAll()) {
            this.pageBuilder.declarePosition();
            for (int column = 0; column < this.columnTypes.size(); ++column) {
                BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                this.appendTo(this.columnTypes.get(column), record.get(column), output);
            }
        }
        this.finished = true;
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private void appendTo(Type type, FieldValue value, BlockBuilder output) {
        block16: {
            if (value == null || value.isNull()) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, value.getBooleanValue());
                    break block16;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals(BigintType.BIGINT)) {
                        type.writeLong(output, value.getLongValue());
                        break block16;
                    }
                    if (type.equals(IntegerType.INTEGER)) {
                        type.writeLong(output, value.getLongValue());
                        break block16;
                    }
                    if (type.equals(DateType.DATE)) {
                        type.writeLong(output, LocalDate.parse(value.getStringValue()).toEpochDay());
                        break block16;
                    }
                    if (type.equals(TimeType.TIME_MICROS)) {
                        LocalTime time = LocalTime.parse(value.getStringValue(), TIME_FORMATTER);
                        long nanosOfDay = time.toNanoOfDay();
                        Verify.verify((nanosOfDay < 86400000000000L ? 1 : 0) != 0, (String)"Invalid value of nanosOfDay: %s", (long)nanosOfDay);
                        long picosOfDay = nanosOfDay * 1000L;
                        long rounded = Timestamps.round((long)picosOfDay, (int)(12 - TimeType.TIME_MICROS.getPrecision()));
                        if (rounded == 86400000000000000L) {
                            rounded = 0L;
                        }
                        type.writeLong(output, rounded);
                        break block16;
                    }
                    if (type.equals(TimestampType.TIMESTAMP_MICROS)) {
                        type.writeLong(output, BigQueryType.toTrinoTimestamp(value.getStringValue()));
                        break block16;
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, value.getDoubleValue());
                    break block16;
                }
                if (type.getJavaType() == Int128.class) {
                    DecimalType decimalType = (DecimalType)type;
                    Verify.verify((!decimalType.isShort() ? 1 : 0) != 0, (String)"The type should be long decimal", (Object[])new Object[0]);
                    BigDecimal decimal = value.getNumericValue();
                    type.writeObject(output, (Object)Decimals.encodeScaledValue((BigDecimal)decimal, (int)decimalType.getScale()));
                    break block16;
                }
                if (javaType == Slice.class) {
                    BigQueryQueryPageSource.writeSlice(output, type, value);
                    break block16;
                }
                if (type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)type;
                    ((ArrayBlockBuilder)output).buildEntry(elementBuilder -> {
                        Type elementType = arrayType.getElementType();
                        for (FieldValue element : value.getRepeatedValue()) {
                            this.appendTo(elementType, element, elementBuilder);
                        }
                    });
                    break block16;
                }
                if (type instanceof RowType) {
                    RowType rowType = (RowType)type;
                    FieldValueList record = value.getRecordValue();
                    List fields = rowType.getFields();
                    ((RowBlockBuilder)output).buildEntry(fieldBuilders -> {
                        for (int index = 0; index < fields.size(); ++index) {
                            this.appendTo(((RowType.Field)fields.get(index)).getType(), record.get(index), (BlockBuilder)fieldBuilders.get(index));
                        }
                    });
                    break block16;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
            }
            catch (ClassCastException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type), (Throwable)e);
            }
        }
    }

    private static void writeSlice(BlockBuilder output, Type type, FieldValue value) {
        if (type instanceof VarcharType) {
            type.writeSlice(output, Slices.utf8Slice((String)value.getStringValue()));
        } else if (type instanceof VarbinaryType) {
            type.writeSlice(output, Slices.wrappedBuffer((byte[])value.getBytesValue()));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + type.getTypeSignature());
        }
    }

    public void close() {
    }
}

