/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.TransferPair;

public class BigQueryArrowToPageConverter
implements AutoCloseable {
    private final VectorSchemaRoot root;
    private final VectorLoader loader;
    private final BufferAllocator allocator;
    private final List<Type> columnTypes;
    private final List<String> columnNames;

    public BigQueryArrowToPageConverter(BufferAllocator allocator, Schema schema, List<BigQueryColumnHandle> columns) {
        this.allocator = Objects.requireNonNull(allocator, "allocator is null");
        this.columnTypes = (List)Objects.requireNonNull(columns, "columns is null").stream().map(BigQueryColumnHandle::getTrinoType).collect(ImmutableList.toImmutableList());
        this.columnNames = (List)columns.stream().map(BigQueryColumnHandle::getName).collect(ImmutableList.toImmutableList());
        List vectors = (List)schema.getFields().stream().map(field -> field.createVector(allocator)).collect(ImmutableList.toImmutableList());
        this.root = new VectorSchemaRoot((Iterable)vectors);
        Verify.verify((vectors.size() == columns.size() ? 1 : 0) != 0, (String)"Vectors, columns size differ", (Object[])new Object[0]);
        this.loader = new VectorLoader(this.root, (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
    }

    public void convert(PageBuilder pageBuilder, ArrowRecordBatch batch) {
        this.loader.load(batch);
        pageBuilder.declarePositions(this.root.getRowCount());
        for (int column = 0; column < this.columnTypes.size(); ++column) {
            this.convertType(pageBuilder.getBlockBuilder(column), this.columnTypes.get(column), this.root.getVector(BigQueryUtil.toBigQueryColumnName(this.columnNames.get(column))), 0, this.root.getVector(BigQueryUtil.toBigQueryColumnName(this.columnNames.get(column))).getValueCount());
        }
        this.root.clear();
    }

    private void convertType(BlockBuilder output, Type type, FieldVector vector, int offset, int length) {
        block16: {
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    this.writeVectorValues(output, vector, index -> type.writeBoolean(output, ((BitVector)vector).get(index.intValue()) == 1), offset, length);
                    break block16;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals(BigintType.BIGINT)) {
                        this.writeVectorValues(output, vector, index -> type.writeLong(output, ((BigIntVector)vector).get(index.intValue())), offset, length);
                        break block16;
                    }
                    if (type.equals(IntegerType.INTEGER)) {
                        this.writeVectorValues(output, vector, index -> type.writeLong(output, (long)((IntVector)vector).get(index.intValue())), offset, length);
                        break block16;
                    }
                    if (type instanceof DecimalType) {
                        DecimalType decimalType = (DecimalType)type;
                        this.writeVectorValues(output, vector, index -> this.writeObjectShortDecimal(output, decimalType, vector, (int)index), offset, length);
                        break block16;
                    }
                    if (type.equals(DateType.DATE)) {
                        this.writeVectorValues(output, vector, index -> type.writeLong(output, (long)((DateDayVector)vector).get(index.intValue())), offset, length);
                        break block16;
                    }
                    if (type.equals(TimestampType.TIMESTAMP_MICROS)) {
                        this.writeVectorValues(output, vector, index -> type.writeLong(output, ((TimeStampVector)vector).get(index.intValue())), offset, length);
                        break block16;
                    }
                    if (type.equals(TimeType.TIME_MICROS)) {
                        this.writeVectorValues(output, vector, index -> type.writeLong(output, ((TimeMicroVector)vector).get(index.intValue()) * 1000000L), offset, length);
                        break block16;
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
                }
                if (javaType == Double.TYPE) {
                    this.writeVectorValues(output, vector, index -> type.writeDouble(output, ((Float8Vector)vector).get(index.intValue())), offset, length);
                    break block16;
                }
                if (type.getJavaType() == Int128.class) {
                    this.writeVectorValues(output, vector, index -> this.writeObjectLongDecimal(output, type, vector, (int)index), offset, length);
                    break block16;
                }
                if (javaType == Slice.class) {
                    this.writeVectorValues(output, vector, index -> this.writeSlice(output, type, vector, (int)index), offset, length);
                    break block16;
                }
                if (javaType == LongTimestampWithTimeZone.class) {
                    this.writeVectorValues(output, vector, index -> this.writeObjectTimestampWithTimezone(output, type, vector, (int)index), offset, length);
                    break block16;
                }
                if (type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)type;
                    this.writeVectorValues(output, vector, index -> this.writeArrayBlock(output, arrayType, vector, (int)index), offset, length);
                    break block16;
                }
                if (type instanceof RowType) {
                    RowType rowType = (RowType)type;
                    this.writeVectorValues(output, vector, index -> this.writeRowBlock(output, rowType, vector, (int)index), offset, length);
                    break block16;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
            }
            catch (ClassCastException ex) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type), (Throwable)ex);
            }
        }
    }

    private void writeVectorValues(BlockBuilder output, FieldVector vector, Consumer<Integer> consumer, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            if (vector.isNull(i)) {
                output.appendNull();
                continue;
            }
            consumer.accept(i);
        }
    }

    private void writeSlice(BlockBuilder output, Type type, FieldVector vector, int index) {
        if (type instanceof VarcharType) {
            byte[] slice = ((VarCharVector)vector).get(index);
            type.writeSlice(output, Slices.wrappedBuffer((byte[])slice));
        } else if (type instanceof VarbinaryType) {
            byte[] slice = ((VarBinaryVector)vector).get(index);
            type.writeSlice(output, Slices.wrappedBuffer((byte[])slice));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + type.getTypeSignature());
        }
    }

    private void writeObjectLongDecimal(BlockBuilder output, Type type, FieldVector vector, int index) {
        if (!(type instanceof DecimalType)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Object: " + type.getTypeSignature());
        }
        DecimalType decimalType = (DecimalType)type;
        Verify.verify((!decimalType.isShort() ? 1 : 0) != 0, (String)"The type should be long decimal", (Object[])new Object[0]);
        BigDecimal decimal = vector.getMinorType() == Types.MinorType.DECIMAL256 ? ((Decimal256Vector)vector).getObject(index) : ((DecimalVector)vector).getObject(index);
        type.writeObject(output, (Object)Decimals.encodeScaledValue((BigDecimal)decimal, (int)decimalType.getScale()));
    }

    private void writeObjectShortDecimal(BlockBuilder output, DecimalType decimalType, FieldVector vector, int index) {
        Verify.verify((boolean)decimalType.isShort(), (String)"The type should be short decimal", (Object[])new Object[0]);
        BigDecimal decimal = vector.getMinorType() == Types.MinorType.DECIMAL256 ? ((Decimal256Vector)vector).getObject(index) : ((DecimalVector)vector).getObject(index);
        decimalType.writeLong(output, Decimals.encodeShortScaledValue((BigDecimal)decimal, (int)decimalType.getScale()));
    }

    private void writeObjectTimestampWithTimezone(BlockBuilder output, Type type, FieldVector vector, int index) {
        Verify.verify((boolean)type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS));
        long epochMicros = ((TimeStampVector)vector).get(index);
        int picosOfMillis = Math.toIntExact(Math.floorMod(epochMicros, 1000)) * 1000000;
        type.writeObject(output, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Math.floorDiv(epochMicros, 1000), (int)picosOfMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
    }

    private void writeArrayBlock(BlockBuilder output, ArrayType arrayType, FieldVector vector, int index) {
        Type elementType = arrayType.getElementType();
        ((ArrayBlockBuilder)output).buildEntry(elementBuilder -> {
            ArrowBuf offsetBuffer = vector.getOffsetBuffer();
            int start = offsetBuffer.getInt((long)index * 4L);
            int end = offsetBuffer.getInt((long)(index + 1) * 4L);
            FieldVector innerVector = ((ListVector)vector).getDataVector();
            TransferPair transferPair = innerVector.getTransferPair(this.allocator);
            transferPair.splitAndTransfer(start, end - start);
            try (FieldVector sliced = (FieldVector)transferPair.getTo();){
                this.convertType(elementBuilder, elementType, sliced, 0, sliced.getValueCount());
            }
        });
    }

    private void writeRowBlock(BlockBuilder output, RowType rowType, FieldVector vector, int index) {
        List fields = rowType.getFields();
        ((RowBlockBuilder)output).buildEntry(fieldBuilders -> {
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                FieldVector innerVector = ((StructVector)vector).getChild((String)((Object)field.getName().orElse("field" + i)));
                this.convertType((BlockBuilder)fieldBuilders.get(i), field.getType(), innerVector, index, 1);
            }
        });
    }

    @Override
    public void close() {
        this.root.close();
    }
}

