/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import io.trino.plugin.bigquery.BigQueryUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ReadRowsHelper {
    private final BigQueryReadClient client;
    private final String streamName;
    private final int maxReadRowsRetries;

    public ReadRowsHelper(BigQueryReadClient client, String streamName, int maxReadRowsRetries) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.streamName = Objects.requireNonNull(streamName, "streamName cannot be null");
        this.maxReadRowsRetries = maxReadRowsRetries;
    }

    public Iterator<ReadRowsResponse> readRows() {
        Iterator<ReadRowsResponse> serverResponses = this.fetchResponses(0L);
        return new ReadRowsIterator(this, serverResponses);
    }

    protected Iterator<ReadRowsResponse> fetchResponses(long offset) {
        return this.client.readRowsCallable().call((Object)ReadRowsRequest.newBuilder().setReadStream(this.streamName).setOffset(offset).build()).iterator();
    }

    private static class ReadRowsIterator
    implements Iterator<ReadRowsResponse> {
        private final ReadRowsHelper helper;
        private long nextOffset;
        private Iterator<ReadRowsResponse> serverResponses;
        private int retries;

        public ReadRowsIterator(ReadRowsHelper helper, Iterator<ReadRowsResponse> serverResponses) {
            this.helper = helper;
            this.serverResponses = serverResponses;
        }

        @Override
        public boolean hasNext() {
            return this.serverResponses.hasNext();
        }

        @Override
        public ReadRowsResponse next() {
            while (true) {
                try {
                    ReadRowsResponse response = this.serverResponses.next();
                    this.nextOffset += response.getRowCount();
                    return response;
                }
                catch (Exception e) {
                    if (BigQueryUtil.isRetryable(e) && this.retries < this.helper.maxReadRowsRetries) {
                        this.serverResponses = this.helper.fetchResponses(this.nextOffset);
                        ++this.retries;
                        continue;
                    }
                    this.helper.client.close();
                    throw e;
                    if (this.serverResponses.hasNext()) continue;
                    throw new NoSuchElementException("No more server responses");
                }
                break;
            }
        }
    }
}

