/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.base.MoreObjects;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class BigQueryTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;
    private final RemoteTableName remoteTableName;
    private final String type;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<List<ColumnHandle>> projectedColumns;
    private final OptionalLong limit;

    @JsonCreator
    public BigQueryTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="remoteTableName") RemoteTableName remoteTableName, @JsonProperty(value="type") String type, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="projectedColumns") Optional<List<ColumnHandle>> projectedColumns, @JsonProperty(value="limit") OptionalLong limit) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.remoteTableName = Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.projectedColumns = Objects.requireNonNull(projectedColumns, "projectedColumns is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    public BigQueryTableHandle(SchemaTableName schemaTableName, RemoteTableName remoteTableName, TableInfo tableInfo) {
        this(schemaTableName, remoteTableName, tableInfo.getDefinition().getType().toString(), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), OptionalLong.empty());
    }

    @JsonProperty
    public RemoteTableName getRemoteTableName() {
        return this.remoteTableName;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Optional<List<ColumnHandle>> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQueryTableHandle that = (BigQueryTableHandle)o;
        return Objects.equals(this.schemaTableName, that.schemaTableName) && Objects.equals(this.type, that.type) && Objects.equals(this.constraint, that.constraint) && Objects.equals(this.projectedColumns, that.projectedColumns) && Objects.equals(this.limit, that.limit);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.type, this.constraint, this.projectedColumns, this.limit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("remoteTableName", (Object)this.remoteTableName).add("schemaTableName", (Object)this.schemaTableName).add("type", (Object)this.type).add("constraint", this.constraint).add("projectedColumns", this.projectedColumns).add("limit", (Object)this.limit).toString();
    }

    BigQueryTableHandle withConstraint(TupleDomain<ColumnHandle> newConstraint) {
        return new BigQueryTableHandle(this.schemaTableName, this.remoteTableName, this.type, newConstraint, this.projectedColumns, this.limit);
    }

    BigQueryTableHandle withProjectedColumns(List<ColumnHandle> newProjectedColumns) {
        return new BigQueryTableHandle(this.schemaTableName, this.remoteTableName, this.type, this.constraint, Optional.of(newProjectedColumns), this.limit);
    }

    BigQueryTableHandle withLimit(long newLimit) {
        return new BigQueryTableHandle(this.schemaTableName, this.remoteTableName, this.type, this.constraint, this.projectedColumns, OptionalLong.of(newLimit));
    }
}

