/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryErrorCode;
import io.trino.plugin.bigquery.BigQueryFilterQueryBuilder;
import io.trino.plugin.bigquery.BigQueryReadClientFactory;
import io.trino.plugin.bigquery.BigQuerySplit;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.ReadSessionCreator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class BigQuerySplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(BigQuerySplitManager.class);
    private final BigQueryClientFactory bigQueryClientFactory;
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final Optional<Integer> parallelism;
    private final boolean viewEnabled;
    private final Duration viewExpiration;
    private final NodeManager nodeManager;

    @Inject
    public BigQuerySplitManager(BigQueryConfig config, BigQueryClientFactory bigQueryClientFactory, BigQueryReadClientFactory bigQueryReadClientFactory, NodeManager nodeManager) {
        Objects.requireNonNull(config, "config cannot be null");
        this.bigQueryClientFactory = Objects.requireNonNull(bigQueryClientFactory, "bigQueryClientFactory cannot be null");
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory cannot be null");
        this.parallelism = config.getParallelism();
        this.viewEnabled = config.isViewsEnabled();
        this.viewExpiration = config.getViewExpiration();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager cannot be null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        log.debug("getSplits(transaction=%s, session=%s, table=%s, splitSchedulingStrategy=%s)", new Object[]{transaction, session, table, splitSchedulingStrategy});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)table;
        TableId remoteTableId = bigQueryTableHandle.getRemoteTableName().toTableId();
        int actualParallelism = this.parallelism.orElse(this.nodeManager.getRequiredWorkerNodes().size());
        TupleDomain<ColumnHandle> constraint = bigQueryTableHandle.getConstraint();
        Optional<String> filter = BigQueryFilterQueryBuilder.buildFilter(constraint);
        List<BigQuerySplit> splits = BigQuerySplitManager.emptyProjectionIsRequired(bigQueryTableHandle.getProjectedColumns()) ? this.createEmptyProjection(session, remoteTableId, actualParallelism, filter) : this.readFromBigQuery(session, remoteTableId, bigQueryTableHandle.getProjectedColumns(), actualParallelism, filter);
        return new FixedSplitSource(splits);
    }

    private static boolean emptyProjectionIsRequired(Optional<List<ColumnHandle>> projectedColumns) {
        return projectedColumns.isPresent() && projectedColumns.get().isEmpty();
    }

    private List<BigQuerySplit> readFromBigQuery(ConnectorSession session, TableId remoteTableId, Optional<List<ColumnHandle>> projectedColumns, int actualParallelism, Optional<String> filter) {
        log.debug("readFromBigQuery(tableId=%s, projectedColumns=%s, actualParallelism=%s, filter=[%s])", new Object[]{remoteTableId, projectedColumns, actualParallelism, filter});
        List<ColumnHandle> columns = projectedColumns.orElse((List<ColumnHandle>)ImmutableList.of());
        List projectedColumnsNames = (List)columns.stream().map(column -> ((BigQueryColumnHandle)column).getName()).collect(ImmutableList.toImmutableList());
        ReadSession readSession = new ReadSessionCreator(this.bigQueryClientFactory, this.bigQueryReadClientFactory, this.viewEnabled, this.viewExpiration).create(session, remoteTableId, projectedColumnsNames, filter, actualParallelism);
        return (List)readSession.getStreamsList().stream().map(stream -> BigQuerySplit.forStream(stream.getName(), readSession.getAvroSchema().getSchema(), columns)).collect(ImmutableList.toImmutableList());
    }

    private List<BigQuerySplit> createEmptyProjection(ConnectorSession session, TableId remoteTableId, int actualParallelism, Optional<String> filter) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("createEmptyProjection(tableId=%s, actualParallelism=%s, filter=[%s])", new Object[]{remoteTableId, actualParallelism, filter});
        try {
            long numberOfRows;
            if (filter.isPresent()) {
                String sql = client.selectSql(remoteTableId, "COUNT(*)");
                TableResult result = client.query(sql);
                numberOfRows = ((FieldValueList)result.iterateAll().iterator().next()).get(0).getLongValue();
            } else {
                TableInfo tableInfo = client.getTable(remoteTableId).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(remoteTableId.getDataset(), remoteTableId.getTable())));
                if (tableInfo.getDefinition().getType() == TableDefinition.Type.TABLE) {
                    numberOfRows = tableInfo.getNumRows().longValue();
                } else if (tableInfo.getDefinition().getType() == TableDefinition.Type.VIEW) {
                    String sql = client.selectSql(remoteTableId, "COUNT(*)");
                    TableResult result = client.query(sql);
                    numberOfRows = ((FieldValueList)result.iterateAll().iterator().next()).get(0).getLongValue();
                } else {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported table type: " + tableInfo.getDefinition().getType());
                }
            }
            long rowsPerSplit = numberOfRows / (long)actualParallelism;
            long remainingRows = numberOfRows - rowsPerSplit * (long)actualParallelism;
            List<BigQuerySplit> splits = IntStream.range(0, actualParallelism).mapToObj(ignored -> BigQuerySplit.emptyProjection(rowsPerSplit)).collect(Collectors.toList());
            splits.set(0, BigQuerySplit.emptyProjection(rowsPerSplit + remainingRows));
            return splits;
        }
        catch (BigQueryException e) {
            throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_FAILED_TO_EXECUTE_QUERY, "Failed to compute empty projection", (Throwable)e);
        }
    }
}

