/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQuerySplit;
import io.trino.plugin.bigquery.BigQueryType;
import io.trino.plugin.bigquery.ReadRowsHelper;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;

public class BigQueryResultPageSource
implements ConnectorPageSource {
    private static final Logger log = Logger.get(BigQueryResultPageSource.class);
    private static final AvroDecimalConverter DECIMAL_CONVERTER = new AvroDecimalConverter();
    private final BigQueryReadClient bigQueryReadClient;
    private final BigQuerySplit split;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final AtomicLong readBytes;
    private final PageBuilder pageBuilder;
    private final Iterator<ReadRowsResponse> responses;

    public BigQueryResultPageSource(BigQueryReadClient bigQueryReadClient, int maxReadRowsRetries, BigQuerySplit split, List<BigQueryColumnHandle> columns) {
        this.bigQueryReadClient = Objects.requireNonNull(bigQueryReadClient, "bigQueryReadClient is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.readBytes = new AtomicLong();
        Objects.requireNonNull(columns, "columns is null");
        this.columnNames = (List)columns.stream().map(BigQueryColumnHandle::getName).collect(ImmutableList.toImmutableList());
        this.columnTypes = (List)columns.stream().map(BigQueryType.Adaptor::getTrinoType).collect(ImmutableList.toImmutableList());
        this.pageBuilder = new PageBuilder(this.columnTypes);
        log.debug("Starting to read from %s", new Object[]{split.getStreamName()});
        this.responses = new ReadRowsHelper(bigQueryReadClient, split.getStreamName(), maxReadRowsRetries).readRows();
    }

    public long getCompletedBytes() {
        return this.readBytes.get();
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return !this.responses.hasNext();
    }

    public Page getNextPage() {
        Preconditions.checkState((boolean)this.pageBuilder.isEmpty(), (Object)"PageBuilder is not empty at the beginning of a new page");
        ReadRowsResponse response = this.responses.next();
        Iterable<GenericRecord> records = this.parse(response);
        for (GenericRecord record : records) {
            this.pageBuilder.declarePosition();
            for (int column = 0; column < this.columnTypes.size(); ++column) {
                BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                this.appendTo(this.columnTypes.get(column), record.get(this.columnNames.get(column)), output);
            }
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private void appendTo(Type type, Object value, BlockBuilder output) {
        block15: {
            if (value == null) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, ((Boolean)value).booleanValue());
                    break block15;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals(BigintType.BIGINT)) {
                        type.writeLong(output, ((Number)value).longValue());
                        break block15;
                    }
                    if (type.equals(IntegerType.INTEGER)) {
                        type.writeLong(output, (long)((Number)value).intValue());
                        break block15;
                    }
                    if (type instanceof DecimalType) {
                        Verify.verify((boolean)Decimals.isShortDecimal((Type)type), (String)"The type should be short decimal", (Object[])new Object[0]);
                        DecimalType decimalType = (DecimalType)type;
                        BigDecimal decimal = DECIMAL_CONVERTER.convert(decimalType.getPrecision(), decimalType.getScale(), value);
                        type.writeLong(output, Decimals.encodeShortScaledValue((BigDecimal)decimal, (int)decimalType.getScale()));
                        break block15;
                    }
                    if (type.equals(DateType.DATE)) {
                        type.writeLong(output, (long)((Number)value).intValue());
                        break block15;
                    }
                    if (type.equals(TimestampType.TIMESTAMP_MICROS)) {
                        type.writeLong(output, BigQueryType.toTrinoTimestamp(((Utf8)value).toString()));
                        break block15;
                    }
                    if (type.equals(TimeType.TIME_MICROS)) {
                        type.writeLong(output, (Long)value * 1000000L);
                        break block15;
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, ((Number)value).doubleValue());
                    break block15;
                }
                if (javaType == Slice.class) {
                    BigQueryResultPageSource.writeSlice(output, type, value);
                    break block15;
                }
                if (javaType == LongTimestampWithTimeZone.class) {
                    Verify.verify((boolean)type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS));
                    long epochMicros = (Long)value;
                    int picosOfMillis = Math.toIntExact(Math.floorMod(epochMicros, 1000)) * 1000000;
                    type.writeObject(output, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)Math.floorDiv(epochMicros, 1000), (int)picosOfMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
                    break block15;
                }
                if (javaType == Block.class) {
                    this.writeBlock(output, type, value);
                    break block15;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
            }
            catch (ClassCastException ignore) {
                output.appendNull();
            }
        }
    }

    private static void writeSlice(BlockBuilder output, Type type, Object value) {
        if (type instanceof VarcharType) {
            type.writeSlice(output, Slices.utf8Slice((String)((Utf8)value).toString()));
        } else if (type instanceof DecimalType) {
            Verify.verify((boolean)Decimals.isLongDecimal((Type)type), (String)"The type should be long decimal", (Object[])new Object[0]);
            DecimalType decimalType = (DecimalType)type;
            BigDecimal decimal = DECIMAL_CONVERTER.convert(decimalType.getPrecision(), decimalType.getScale(), value);
            type.writeSlice(output, Decimals.encodeScaledValue((BigDecimal)decimal, (int)decimalType.getScale()));
        } else if (type instanceof VarbinaryType) {
            if (value instanceof ByteBuffer) {
                type.writeSlice(output, Slices.wrappedBuffer((ByteBuffer)((ByteBuffer)value)));
            } else {
                output.appendNull();
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + type.getTypeSignature());
        }
    }

    private void writeBlock(BlockBuilder output, Type type, Object value) {
        if (type instanceof ArrayType && value instanceof List) {
            BlockBuilder builder = output.beginBlockEntry();
            for (Object element : (List)value) {
                this.appendTo((Type)type.getTypeParameters().get(0), element, builder);
            }
            output.closeEntry();
            return;
        }
        if (type instanceof RowType && value instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)value;
            BlockBuilder builder = output.beginBlockEntry();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (int i = 0; i < type.getTypeSignature().getParameters().size(); ++i) {
                TypeSignatureParameter parameter = (TypeSignatureParameter)type.getTypeSignature().getParameters().get(i);
                fieldNames.add((String)((Object)parameter.getNamedTypeSignature().getName().orElse("field" + i)));
            }
            Preconditions.checkState((fieldNames.size() == type.getTypeParameters().size() ? 1 : 0) != 0, (String)"fieldName doesn't match with type size : %s", (Object)type);
            for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                this.appendTo((Type)type.getTypeParameters().get(index), record.get((String)fieldNames.get(index)), builder);
            }
            output.closeEntry();
            return;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Block: " + type.getTypeSignature());
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.bigQueryReadClient.close();
    }

    Iterable<GenericRecord> parse(ReadRowsResponse response) {
        byte[] buffer = response.getAvroRows().getSerializedBinaryRows().toByteArray();
        this.readBytes.addAndGet(buffer.length);
        log.debug("Read %d bytes (total %d) from %s", new Object[]{buffer.length, this.readBytes.get(), this.split.getStreamName()});
        Schema avroSchema = new Schema.Parser().parse(this.split.getAvroSchema());
        return () -> new AvroBinaryIterator(avroSchema, buffer);
    }

    static class AvroDecimalConverter {
        private static final Conversions.DecimalConversion AVRO_DECIMAL_CONVERSION = new Conversions.DecimalConversion();

        AvroDecimalConverter() {
        }

        BigDecimal convert(int precision, int scale, Object value) {
            Schema schema = new Schema.Parser().parse(String.format("{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":%d,\"scale\":%d}", precision, scale));
            return AVRO_DECIMAL_CONVERSION.fromBytes((ByteBuffer)value, schema, schema.getLogicalType());
        }
    }

    private static class AvroBinaryIterator
    implements Iterator<GenericRecord> {
        GenericDatumReader<GenericRecord> reader;
        BinaryDecoder in;

        AvroBinaryIterator(Schema avroSchema, byte[] buffer) {
            this.reader = new GenericDatumReader(avroSchema);
            this.in = new DecoderFactory().binaryDecoder(buffer, null);
        }

        @Override
        public boolean hasNext() {
            try {
                return !this.in.isEnd();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error determining the end of Avro buffer", e);
            }
        }

        @Override
        public GenericRecord next() {
            try {
                return (GenericRecord)this.reader.read(null, (Decoder)this.in);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading next Avro Record", e);
            }
        }
    }
}

