/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryErrorCode;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.BigQueryType;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;

public class BigQueryMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(BigQueryMetadata.class);
    static final int DEFAULT_NUMERIC_TYPE_PRECISION = 38;
    static final int DEFAULT_NUMERIC_TYPE_SCALE = 9;
    static final String INFORMATION_SCHEMA = "information_schema";
    private static final String VIEW_DEFINITION_SYSTEM_TABLE_SUFFIX = "$view_definition";
    private final BigQueryClientFactory bigQueryClientFactory;
    private final Optional<String> configProjectId;

    @Inject
    public BigQueryMetadata(BigQueryClientFactory bigQueryClientFactory, BigQueryConfig config) {
        this.bigQueryClientFactory = Objects.requireNonNull(bigQueryClientFactory, "bigQueryClientFactory is null");
        this.configProjectId = Objects.requireNonNull(config, "config is null").getProjectId();
    }

    protected String getProjectId(BigQueryClient client) {
        String projectId = this.configProjectId.orElse(client.getProjectId());
        Preconditions.checkState((boolean)projectId.toLowerCase(Locale.ENGLISH).equals(projectId), (Object)("projectId must be lowercase but it's " + projectId));
        return projectId;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        log.debug("listSchemaNames(session=%s)", new Object[]{session});
        return (List)this.listRemoteSchemaNames(session).stream().map(schema -> schema.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }

    private List<String> listRemoteSchemaNames(ConnectorSession session) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        String projectId = this.getProjectId(client);
        Stream<String> remoteSchemaNames = Streams.stream(client.listDatasets(projectId)).map(dataset -> dataset.getDatasetId().getDataset()).filter(schemaName -> !schemaName.equalsIgnoreCase(INFORMATION_SCHEMA)).distinct();
        return (List)remoteSchemaNames.map(remoteSchema -> client.toRemoteDataset(projectId, remoteSchema.toLowerCase(Locale.ENGLISH))).filter(Optional::isPresent).map(Optional::get).filter(dataset -> !dataset.isAmbiguous()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).collect(ImmutableList.toImmutableList());
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("schemaExists(session=%s)", new Object[]{session});
        String projectId = this.getProjectId(client);
        return client.toRemoteDataset(projectId, schemaName).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).filter(remoteSchema -> client.getDataset(DatasetId.of((String)projectId, (String)remoteSchema)) != null).isPresent();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("listTables(session=%s, schemaName=%s)", new Object[]{session, schemaName});
        if (schemaName.isPresent() && schemaName.get().equalsIgnoreCase(INFORMATION_SCHEMA)) {
            return ImmutableList.of();
        }
        String projectId = this.getProjectId(client);
        Optional<ImmutableSet> remoteSchema = schemaName.flatMap(schema -> client.toRemoteDataset(projectId, (String)schema).filter(dataset -> !dataset.isAmbiguous()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName));
        if (remoteSchema.isPresent() && ((String)remoteSchema.get()).equalsIgnoreCase(INFORMATION_SCHEMA)) {
            return ImmutableList.of();
        }
        Set remoteSchemaNames = (Set)remoteSchema.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf(this.listRemoteSchemaNames(session)));
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String remoteSchemaName : remoteSchemaNames) {
            try {
                Iterable<Table> tables = client.listTables(DatasetId.of((String)projectId, (String)remoteSchemaName), TableDefinition.Type.TABLE, TableDefinition.Type.VIEW);
                for (Table table : tables) {
                    client.toRemoteTable(projectId, remoteSchemaName, table.getTableId().getTable().toLowerCase(Locale.ENGLISH), tables).filter(BigQueryClient.RemoteDatabaseObject::isAmbiguous).ifPresentOrElse(remoteTable -> log.debug("Filtered out [%s.%s] from list of tables due to ambiguous name", new Object[]{remoteSchemaName, table.getTableId().getTable()}), () -> tableNames.add((Object)new SchemaTableName(table.getTableId().getDataset(), table.getTableId().getTable())));
                }
            }
            catch (BigQueryException e) {
                if (e.getCode() == 404 && e.getMessage().contains("Not found: Dataset")) {
                    log.debug("Dataset disappeared during listing operation: %s", new Object[]{remoteSchemaName});
                    continue;
                }
                throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_LISTING_DATASET_ERROR, "Exception happened during listing BigQuery dataset: " + remoteSchemaName, (Throwable)e);
            }
        }
        return tableNames.build();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        String projectId = this.getProjectId(client);
        log.debug("getTableHandle(session=%s, schemaTableName=%s)", new Object[]{session, schemaTableName});
        String remoteSchemaName = client.toRemoteDataset(projectId, schemaTableName.getSchemaName()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElse(schemaTableName.getSchemaName());
        String remoteTableName = client.toRemoteTable(projectId, remoteSchemaName, schemaTableName.getTableName()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElse(schemaTableName.getTableName());
        Optional<TableInfo> tableInfo = client.getTable(TableId.of((String)projectId, (String)remoteSchemaName, (String)remoteTableName));
        if (tableInfo.isEmpty()) {
            log.debug("Table [%s.%s] was not found", new Object[]{schemaTableName.getSchemaName(), schemaTableName.getTableName()});
            return null;
        }
        return new BigQueryTableHandle(schemaTableName, new RemoteTableName(tableInfo.get().getTableId()), tableInfo.get());
    }

    private ConnectorTableHandle getTableHandleIgnoringConflicts(ConnectorSession session, SchemaTableName schemaTableName) {
        String remoteTableName;
        String remoteSchemaName;
        String projectId;
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        Optional<TableInfo> tableInfo = client.getTable(TableId.of((String)(projectId = this.getProjectId(client)), (String)(remoteSchemaName = client.toRemoteDataset(projectId, schemaTableName.getSchemaName()).map(BigQueryClient.RemoteDatabaseObject::getAnyRemoteName).orElse(schemaTableName.getSchemaName())), (String)(remoteTableName = client.toRemoteTable(projectId, remoteSchemaName, schemaTableName.getTableName()).map(BigQueryClient.RemoteDatabaseObject::getAnyRemoteName).orElse(schemaTableName.getTableName()))));
        if (tableInfo.isEmpty()) {
            log.debug("Table [%s.%s] was not found", new Object[]{schemaTableName.getSchemaName(), schemaTableName.getTableName()});
            return null;
        }
        return new BigQueryTableHandle(schemaTableName, new RemoteTableName(tableInfo.get().getTableId()), tableInfo.get());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("getTableMetadata(session=%s, tableHandle=%s)", new Object[]{session, tableHandle});
        BigQueryTableHandle handle = (BigQueryTableHandle)tableHandle;
        ImmutableList.Builder columnMetadata = ImmutableList.builder();
        for (BigQueryColumnHandle column : client.getColumns(handle)) {
            columnMetadata.add((Object)column.getColumnMetadata());
        }
        return new ConnectorTableMetadata(handle.getSchemaTableName(), (List)columnMetadata.build());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        if (BigQueryMetadata.isViewDefinitionSystemTable(tableName)) {
            return this.getViewDefinitionSystemTable(session, tableName, BigQueryMetadata.getViewDefinitionSourceTableName(tableName));
        }
        return Optional.empty();
    }

    private Optional<SystemTable> getViewDefinitionSystemTable(ConnectorSession session, SchemaTableName viewDefinitionTableName, SchemaTableName sourceTableName) {
        String remoteTableName;
        String remoteSchemaName;
        String projectId;
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        TableInfo tableInfo = client.getTable(TableId.of((String)(projectId = this.getProjectId(client)), (String)(remoteSchemaName = client.toRemoteDataset(projectId, sourceTableName.getSchemaName()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElseThrow(() -> new TableNotFoundException(viewDefinitionTableName))), (String)(remoteTableName = client.toRemoteTable(projectId, remoteSchemaName, sourceTableName.getTableName()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElseThrow(() -> new TableNotFoundException(viewDefinitionTableName))))).orElseThrow(() -> new TableNotFoundException(viewDefinitionTableName));
        if (!(tableInfo.getDefinition() instanceof ViewDefinition)) {
            throw new TableNotFoundException(viewDefinitionTableName);
        }
        ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("query", (Type)VarcharType.VARCHAR));
        List types = (List)columns.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        Optional<String> query = Optional.ofNullable(((ViewDefinition)tableInfo.getDefinition()).getQuery());
        ImmutableList propertyValues = ImmutableList.of((Object)ImmutableList.of((Object)query.orElse("NULL")));
        return Optional.of(BigQueryMetadata.createSystemTable(new ConnectorTableMetadata(sourceTableName, (List)columns), arg_0 -> BigQueryMetadata.lambda$getViewDefinitionSystemTable$14(types, (Iterable)propertyValues, arg_0)));
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("getColumnHandles(session=%s, tableHandle=%s)", new Object[]{session, tableHandle});
        return (Map)client.getColumns((BigQueryTableHandle)tableHandle).stream().collect(ImmutableMap.toImmutableMap(columnHandle -> columnHandle.getColumnMetadata().getName(), Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        log.debug("getColumnMetadata(session=%s, tableHandle=%s, columnHandle=%s)", new Object[]{session, columnHandle, columnHandle});
        return ((BigQueryColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        log.debug("listTableColumns(session=%s, prefix=%s)", new Object[]{session, prefix});
        ImmutableMap.Builder columns = ImmutableMap.builder();
        List tables = prefix.toOptionalSchemaTableName().map(ImmutableList::of).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        for (SchemaTableName tableName : tables) {
            try {
                Optional.ofNullable(this.getTableHandleIgnoringConflicts(session, tableName)).ifPresent(tableHandle -> columns.put((Object)tableName, (Object)this.getTableMetadata(session, (ConnectorTableHandle)tableHandle).getColumns()));
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        log.debug("getTableProperties(session=%s, prefix=%s)", new Object[]{session, table});
        return new ConnectorTableProperties();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        Preconditions.checkArgument((boolean)properties.isEmpty(), (Object)"Can't have properties for schema creation");
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)schemaName).build();
        client.createSchema(datasetInfo);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        String remoteSchemaName = client.toRemoteDataset(this.getProjectId(client), schemaName).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        client.dropSchema(DatasetId.of((String)remoteSchemaName));
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        try {
            this.createTable(session, tableMetadata);
        }
        catch (BigQueryException e) {
            if (ignoreExisting && e.getCode() == 409) {
                return;
            }
            throw e;
        }
    }

    private void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List fields = (List)tableMetadata.getColumns().stream().map(column -> BigQueryType.toField(column.getName(), column.getType())).collect(ImmutableList.toImmutableList());
        TableId tableId = TableId.of((String)schemaName, (String)tableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)Schema.of((Iterable)fields));
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).build();
        this.bigQueryClientFactory.create(session).createTable(tableInfo);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        BigQueryTableHandle bigQueryTable = (BigQueryTableHandle)tableHandle;
        TableId tableId = bigQueryTable.getRemoteTableName().toTableId();
        client.dropTable(tableId);
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle handle, long limit) {
        log.debug("applyLimit(session=%s, handle=%s, limit=%s)", new Object[]{session, handle, limit});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)handle;
        if (bigQueryTableHandle.getLimit().isPresent() && bigQueryTableHandle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        bigQueryTableHandle = bigQueryTableHandle.withLimit(limit);
        return Optional.of(new LimitApplicationResult((Object)bigQueryTableHandle, false, false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        log.debug("applyProjection(session=%s, handle=%s, projections=%s, assignments=%s)", new Object[]{session, handle, projections, assignments});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)handle;
        List newColumns = (List)assignments.values().stream().collect(ImmutableList.toImmutableList());
        if (bigQueryTableHandle.getProjectedColumns().isPresent() && BigQueryMetadata.containSameElements(newColumns, (Iterable<? extends ColumnHandle>)bigQueryTableHandle.getProjectedColumns().get())) {
            return Optional.empty();
        }
        ImmutableList.Builder projectedColumns = ImmutableList.builder();
        ImmutableList.Builder assignmentList = ImmutableList.builder();
        assignments.forEach((name, column) -> {
            projectedColumns.add(column);
            assignmentList.add((Object)new Assignment(name, column, ((BigQueryColumnHandle)column).getTrinoType()));
        });
        bigQueryTableHandle = bigQueryTableHandle.withProjectedColumns((List<ColumnHandle>)projectedColumns.build());
        return Optional.of(new ProjectionApplicationResult((Object)bigQueryTableHandle, projections, (List)assignmentList.build(), false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        log.debug("applyFilter(session=%s, handle=%s, summary=%s, predicate=%s, columns=%s)", new Object[]{session, handle, constraint.getSummary(), constraint.predicate(), constraint.getPredicateColumns()});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)handle;
        TupleDomain<ColumnHandle> oldDomain = bigQueryTableHandle.getConstraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        BigQueryTableHandle updatedHandle = bigQueryTableHandle.withConstraint((TupleDomain<ColumnHandle>)newDomain);
        return Optional.of(new ConstraintApplicationResult((Object)updatedHandle, constraint.getSummary(), false));
    }

    private static boolean containSameElements(Iterable<? extends ColumnHandle> first, Iterable<? extends ColumnHandle> second) {
        return ImmutableSet.copyOf(first).equals((Object)ImmutableSet.copyOf(second));
    }

    private static boolean isViewDefinitionSystemTable(SchemaTableName table) {
        return table.getTableName().endsWith(VIEW_DEFINITION_SYSTEM_TABLE_SUFFIX) && table.getTableName().length() > VIEW_DEFINITION_SYSTEM_TABLE_SUFFIX.length();
    }

    private static SchemaTableName getViewDefinitionSourceTableName(SchemaTableName table) {
        return new SchemaTableName(table.getSchemaName(), table.getTableName().substring(0, table.getTableName().length() - VIEW_DEFINITION_SYSTEM_TABLE_SUFFIX.length()));
    }

    private static SystemTable createSystemTable(final ConnectorTableMetadata metadata, final Function<TupleDomain<Integer>, RecordCursor> cursor) {
        return new SystemTable(){

            public SystemTable.Distribution getDistribution() {
                return SystemTable.Distribution.SINGLE_COORDINATOR;
            }

            public ConnectorTableMetadata getTableMetadata() {
                return metadata;
            }

            public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
                return (RecordCursor)cursor.apply(constraint);
            }
        };
    }

    private static /* synthetic */ RecordCursor lambda$getViewDefinitionSystemTable$14(List types, Iterable propertyValues, TupleDomain constraint) {
        return new InMemoryRecordSet((Collection)types, propertyValues).cursor();
    }
}

