/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.airlift.log.Logger;
import io.trino.plugin.bigquery.BigQueryMetadata;
import io.trino.plugin.bigquery.BigQueryPageSourceProvider;
import io.trino.plugin.bigquery.BigQuerySplitManager;
import io.trino.plugin.bigquery.BigQueryTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class BigQueryConnector
implements Connector {
    private static final Logger log = Logger.get(BigQueryConnector.class);
    private final BigQueryMetadata metadata;
    private final BigQuerySplitManager splitManager;
    private final BigQueryPageSourceProvider pageSourceProvider;

    @Inject
    public BigQueryConnector(BigQueryMetadata metadata, BigQuerySplitManager splitManager, BigQueryPageSourceProvider pageSourceProvider) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        log.debug("beginTransaction(isolationLevel=%s, readOnly=%s)", new Object[]{isolationLevel, readOnly});
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return BigQueryTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }
}

