/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigHidden;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class BigQueryConfig {
    public static final int DEFAULT_MAX_READ_ROWS_RETRIES = 3;
    public static final String VIEWS_ENABLED = "bigquery.views-enabled";
    private Optional<String> projectId = Optional.empty();
    private Optional<String> parentProjectId = Optional.empty();
    private Optional<Integer> parallelism = Optional.empty();
    private boolean viewsEnabled;
    private Optional<String> viewMaterializationProject = Optional.empty();
    private Optional<String> viewMaterializationDataset = Optional.empty();
    private int maxReadRowsRetries = 3;
    private boolean caseInsensitiveNameMatching;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(1.0, TimeUnit.MINUTES);
    private Duration viewsCacheTtl = new Duration(15.0, TimeUnit.MINUTES);
    private Duration serviceCacheTtl = new Duration(3.0, TimeUnit.MINUTES);

    public Optional<String> getProjectId() {
        return this.projectId;
    }

    @Config(value="bigquery.project-id")
    @ConfigDescription(value="The Google Cloud Project ID where the data reside")
    public BigQueryConfig setProjectId(String projectId) {
        this.projectId = Optional.ofNullable(projectId);
        return this;
    }

    public Optional<String> getParentProjectId() {
        return this.parentProjectId;
    }

    @Config(value="bigquery.parent-project-id")
    @ConfigDescription(value="The Google Cloud Project ID to bill for the export")
    public BigQueryConfig setParentProjectId(String parentProjectId) {
        this.parentProjectId = Optional.ofNullable(parentProjectId);
        return this;
    }

    public Optional<Integer> getParallelism() {
        return this.parallelism;
    }

    @Config(value="bigquery.parallelism")
    @ConfigDescription(value="The number of partitions to split the data into.")
    public BigQueryConfig setParallelism(Integer parallelism) {
        this.parallelism = Optional.ofNullable(parallelism);
        return this;
    }

    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    @Config(value="bigquery.views-enabled")
    @ConfigDescription(value="Enables the connector to read from views and not only tables")
    public BigQueryConfig setViewsEnabled(boolean viewsEnabled) {
        this.viewsEnabled = viewsEnabled;
        return this;
    }

    public Duration getViewExpiration() {
        return new Duration(24.0, TimeUnit.HOURS);
    }

    public Optional<String> getViewMaterializationProject() {
        return this.viewMaterializationProject;
    }

    @Config(value="bigquery.view-materialization-project")
    @ConfigDescription(value="The project where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationProject(String viewMaterializationProject) {
        this.viewMaterializationProject = Optional.ofNullable(viewMaterializationProject);
        return this;
    }

    public Optional<String> getViewMaterializationDataset() {
        return this.viewMaterializationDataset;
    }

    @Config(value="bigquery.view-materialization-dataset")
    @ConfigDescription(value="The dataset where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationDataset(String viewMaterializationDataset) {
        this.viewMaterializationDataset = Optional.ofNullable(viewMaterializationDataset);
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    @Config(value="bigquery.max-read-rows-retries")
    @ConfigDescription(value="The number of retries in case of retryable server issues")
    public BigQueryConfig setMaxReadRowsRetries(int maxReadRowsRetries) {
        this.maxReadRowsRetries = maxReadRowsRetries;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="bigquery.case-insensitive-name-matching")
    @ConfigDescription(value="Match dataset and table names case-insensitively")
    public BigQueryConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="bigquery.case-insensitive-name-matching.cache-ttl")
    @ConfigDescription(value="Duration for which remote dataset and table names will be cached")
    public BigQueryConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="0m")
    public @NotNull @MinDuration(value="0m") Duration getViewsCacheTtl() {
        return this.viewsCacheTtl;
    }

    @Config(value="bigquery.views-cache-ttl")
    @ConfigDescription(value="Duration for which the materialization of a view will be cached and reused")
    public BigQueryConfig setViewsCacheTtl(Duration viewsCacheTtl) {
        this.viewsCacheTtl = viewsCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="0m")
    public @NotNull @MinDuration(value="0m") Duration getServiceCacheTtl() {
        return this.serviceCacheTtl;
    }

    @ConfigHidden
    @Config(value="bigquery.service-cache-ttl")
    @ConfigDescription(value="Duration for which BigQuery client service instances are cached")
    public BigQueryConfig setServiceCacheTtl(Duration serviceCacheTtl) {
        this.serviceCacheTtl = serviceCacheTtl;
        return this;
    }
}

