/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.IdentityCacheMapping;
import io.trino.plugin.bigquery.ViewMaterializationCache;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class BigQueryClientFactory {
    private final IdentityCacheMapping identityCacheMapping;
    private final BigQueryCredentialsSupplier credentialsSupplier;
    private final BigQueryConfig bigQueryConfig;
    private final ViewMaterializationCache materializationCache;
    private final HeaderProvider headerProvider;
    private final Cache<IdentityCacheMapping.IdentityCacheKey, BigQueryClient> clientCache;

    @Inject
    public BigQueryClientFactory(IdentityCacheMapping identityCacheMapping, BigQueryCredentialsSupplier credentialsSupplier, BigQueryConfig bigQueryConfig, ViewMaterializationCache materializationCache, HeaderProvider headerProvider) {
        this.identityCacheMapping = Objects.requireNonNull(identityCacheMapping, "identityCacheMaping is null");
        this.credentialsSupplier = Objects.requireNonNull(credentialsSupplier, "credentialsSupplier is null");
        this.bigQueryConfig = Objects.requireNonNull(bigQueryConfig, "bigQueryConfig is null");
        this.materializationCache = Objects.requireNonNull(materializationCache, "materializationCache is null");
        this.headerProvider = Objects.requireNonNull(headerProvider, "headerProvider is null");
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(bigQueryConfig.getServiceCacheTtl().toMillis(), TimeUnit.MILLISECONDS);
        this.clientCache = cacheBuilder.build();
    }

    public BigQueryClient create(ConnectorSession session) {
        IdentityCacheMapping.IdentityCacheKey cacheKey = this.identityCacheMapping.getRemoteUserCacheKey(session);
        try {
            return (BigQueryClient)this.clientCache.get((Object)cacheKey, () -> this.createBigQueryClient(session));
        }
        catch (ExecutionException e) {
            return this.createBigQueryClient(session);
        }
    }

    protected BigQueryClient createBigQueryClient(ConnectorSession session) {
        return new BigQueryClient(this.createBigQuery(session), this.bigQueryConfig, this.materializationCache);
    }

    protected BigQuery createBigQuery(ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        String billingProjectId = BigQueryClientFactory.calculateBillingProjectId(this.bigQueryConfig.getParentProjectId(), credentials);
        BigQueryOptions.Builder options = (BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setHeaderProvider(this.headerProvider)).setProjectId(billingProjectId);
        credentials.ifPresent(arg_0 -> ((BigQueryOptions.Builder)options).setCredentials(arg_0));
        return (BigQuery)options.build().getService();
    }

    static String calculateBillingProjectId(Optional<String> configParentProjectId, Optional<Credentials> credentials) {
        return configParentProjectId.orElseGet(() -> credentials.filter(ServiceAccountCredentials.class::isInstance).map(ServiceAccountCredentials.class::cast).map(ServiceAccountCredentials::getProjectId).orElseGet(ServiceOptions::getDefaultProjectId));
    }
}

