/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.trino.array.ObjectBigArray;
import io.trino.array.ReferenceCountMap;

public final class SliceBigArray {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SliceBigArray.class);
    private static final int SLICE_INSTANCE_SIZE = SizeOf.instanceSize(Slice.class);
    private final ObjectBigArray<Slice> array;
    private final ReferenceCountMap trackedSlices = new ReferenceCountMap();
    private long sizeOfSlices;

    public SliceBigArray() {
        this.array = new ObjectBigArray();
    }

    public SliceBigArray(Slice slice) {
        this.array = new ObjectBigArray(slice);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfSlices + this.trackedSlices.sizeOf();
    }

    public Slice get(long index) {
        return this.array.get(index);
    }

    public void set(long index, Slice value) {
        this.updateRetainedSize(index, value);
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }

    private void updateRetainedSize(long index, Slice value) {
        int sliceReferenceCount;
        int baseReferenceCount;
        Slice currentValue = this.array.get(index);
        if (currentValue != null) {
            baseReferenceCount = this.trackedSlices.decrementAndGet(currentValue.getBase());
            sliceReferenceCount = this.trackedSlices.decrementAndGet(currentValue);
            if (baseReferenceCount == 0) {
                this.sizeOfSlices -= currentValue.getRetainedSize();
            } else if (sliceReferenceCount == 0) {
                this.sizeOfSlices -= (long)SLICE_INSTANCE_SIZE;
            }
        }
        if (value != null) {
            baseReferenceCount = this.trackedSlices.incrementAndGet(value.getBase());
            sliceReferenceCount = this.trackedSlices.incrementAndGet(value);
            if (baseReferenceCount == 1) {
                this.sizeOfSlices += value.getRetainedSize();
            } else if (sliceReferenceCount == 1) {
                this.sizeOfSlices += (long)SLICE_INSTANCE_SIZE;
            }
        }
    }
}

