/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;

public class VectorBatchDebug {
    private static final Logger LOG = LoggerFactory.getLogger(VectorBatchDebug.class);

    public static String displayBytes(byte[] bytes, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            char ch = (char)bytes[i];
            if (ch < ' ' || ch > '~') {
                sb.append(String.format("\\%03d", bytes[i] & 0xFF));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void debugDisplayOneRow(VectorizedRowBatch batch, int index, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix + " row " + index + " ");
        for (int p = 0; p < batch.projectionSize; ++p) {
            int column = batch.projectedColumns[p];
            if (p == column) {
                sb.append("(col " + p + ") ");
            } else {
                sb.append("(proj col " + p + " col " + column + ") ");
            }
            ColumnVector colVector = batch.cols[column];
            if (colVector == null) {
                sb.append("(null ColumnVector)");
            } else {
                boolean isRepeating = colVector.isRepeating;
                if (isRepeating) {
                    sb.append("(repeating)");
                }
                int n = index = isRepeating ? 0 : index;
                if (colVector.noNulls || !colVector.isNull[index]) {
                    if (colVector instanceof LongColumnVector) {
                        sb.append(((LongColumnVector)colVector).vector[index]);
                    } else if (colVector instanceof DoubleColumnVector) {
                        sb.append(((DoubleColumnVector)colVector).vector[index]);
                    } else if (colVector instanceof BytesColumnVector) {
                        BytesColumnVector bytesColumnVector = (BytesColumnVector)colVector;
                        byte[] bytes = bytesColumnVector.vector[index];
                        int start = bytesColumnVector.start[index];
                        int length = bytesColumnVector.length[index];
                        if (bytes == null) {
                            sb.append("(Unexpected null bytes with start " + start + " length " + length + ")");
                        } else {
                            sb.append("bytes: '" + VectorBatchDebug.displayBytes(bytes, start, length) + "'");
                        }
                    } else if (colVector instanceof DecimalColumnVector) {
                        sb.append(((DecimalColumnVector)colVector).vector[index].toString());
                    } else if (colVector instanceof TimestampColumnVector) {
                        Timestamp timestamp = new Timestamp(0L);
                        ((TimestampColumnVector)colVector).timestampUpdate(timestamp, index);
                        sb.append(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli(timestamp.getTime(), timestamp.getNanos()).toString());
                    } else if (colVector instanceof IntervalDayTimeColumnVector) {
                        HiveIntervalDayTime intervalDayTime = ((IntervalDayTimeColumnVector)colVector).asScratchIntervalDayTime(index);
                        sb.append(intervalDayTime.toString());
                    } else {
                        sb.append("Unknown");
                    }
                } else {
                    sb.append("NULL");
                }
            }
            sb.append(" ");
        }
        System.err.println(sb.toString());
    }

    public static void debugDisplayBatch(VectorizedRowBatch batch, String prefix) {
        for (int i = 0; i < batch.size; ++i) {
            int index = batch.selectedInUse ? batch.selected[i] : i;
            VectorBatchDebug.debugDisplayOneRow(batch, index, prefix);
        }
    }
}

