/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

public class VectorAggregationBufferBatch {
    private final VectorAggregationBufferRow[] aggregationBuffers = new VectorAggregationBufferRow[1024];
    private final VectorAggregationBufferRow[] distinctAggregationBuffers = new VectorAggregationBufferRow[1024];
    private int version;
    private int distinctCount;
    private long aggregatorsFixedSize;
    private int[] variableSizeAggregators;

    public boolean getHasVariableSize() {
        return this.variableSizeAggregators.length > 0;
    }

    public long getAggregatorsFixedSize() {
        return this.aggregatorsFixedSize;
    }

    public VectorAggregationBufferRow[] getAggregationBuffers() {
        return this.aggregationBuffers;
    }

    public int getDistinctBufferSetCount() {
        return this.distinctCount;
    }

    public void startBatch() {
        ++this.version;
        this.distinctCount = 0;
    }

    public void mapAggregationBufferSet(VectorAggregationBufferRow bufferSet, int row) {
        if (this.version != bufferSet.getVersion()) {
            bufferSet.setVersionAndIndex(this.version, this.distinctCount);
            this.distinctAggregationBuffers[this.distinctCount] = bufferSet;
            ++this.distinctCount;
        }
        this.aggregationBuffers[row] = bufferSet;
    }

    public void compileAggregationBatchInfo(VectorAggregateExpression[] aggregators) {
        JavaDataModel model = JavaDataModel.get();
        int[] variableSizeAggregators = new int[aggregators.length];
        int indexVariableSizes = 0;
        this.aggregatorsFixedSize = JavaDataModel.alignUp(model.object() + model.primitive1() * 2 + model.ref(), model.memoryAlign());
        this.aggregatorsFixedSize += model.lengthForObjectArrayOfSize(aggregators.length);
        for (int i = 0; i < aggregators.length; ++i) {
            VectorAggregateExpression aggregator = aggregators[i];
            this.aggregatorsFixedSize += aggregator.getAggregationBufferFixedSize();
            if (!aggregator.hasVariableSize()) continue;
            variableSizeAggregators[indexVariableSizes] = i;
            ++indexVariableSizes;
        }
        this.variableSizeAggregators = Arrays.copyOfRange(variableSizeAggregators, 0, indexVariableSizes);
    }

    public int getVariableSize(int batchSize) {
        int variableSize = 0;
        for (int i = 0; i < this.variableSizeAggregators.length; ++i) {
            for (int r = 0; r < this.distinctCount; ++r) {
                VectorAggregationBufferRow buf = this.distinctAggregationBuffers[r];
                variableSize += buf.getAggregationBuffer(this.variableSizeAggregators[i]).getVariableSize();
            }
        }
        return variableSize * batchSize / this.distinctCount;
    }
}

